/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.wizards;

import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipsetrader.core.ats.ScriptStrategy;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.ats.wizards.BarsPage;
import org.eclipsetrader.ui.internal.ats.wizards.InstrumentsPage;
import org.eclipsetrader.ui.internal.ats.wizards.Messages;
import org.eclipsetrader.ui.internal.ats.wizards.NamePage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ScriptStrategyWizard
extends Wizard
implements INewWizard {
    private Image image;
    private NamePage namePage;
    private InstrumentsPage instrumentsPage;
    private BarsPage barsPage;
    private IWorkbench workbench;

    public ScriptStrategyWizard() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)UIActivator.getDefault().getBundle().getResource("icons/wizban/newfile_wiz.gif"));
        this.image = descriptor.createImage();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void addPages() {
        this.namePage = new NamePage();
        this.addPage((IWizardPage)this.namePage);
        this.instrumentsPage = new InstrumentsPage();
        this.addPage((IWizardPage)this.instrumentsPage);
        this.barsPage = new BarsPage();
        this.addPage((IWizardPage)this.barsPage);
    }

    public String getWindowTitle() {
        return Messages.ScriptStrategyWizard_NewScriptStrategy;
    }

    public Image getDefaultPageImage() {
        return this.image;
    }

    public boolean performFinish() {
        final IRepository repository = this.namePage.getRepository();
        final ScriptStrategy resource = new ScriptStrategy(this.namePage.getScriptName());
        resource.setInstruments(this.instrumentsPage.getInstruments());
        resource.setBarsTimeSpan(this.barsPage.getValues());
        BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IRepositoryService.class);
        final IRepositoryService service = (IRepositoryService)bundleContext.getService(serviceReference);
        service.runInService(new IRepositoryRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                service.moveAdaptable(new IAdaptable[]{resource}, repository);
                return Status.OK_STATUS;
            }
        }, null);
        bundleContext.ungetService(serviceReference);
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            IStoreObject storeObject = (IStoreObject)resource.getAdapter(IStoreObject.class);
            IDialogSettings dialogSettings = UIActivator.getDefault().getDialogSettingsForView(storeObject.getStore().toURI());
            page.showView("org.eclipsetrader.ui.editors.script", dialogSettings.getName(), 1);
        }
        catch (PartInitException e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error opening script editor", (Throwable)e);
            UIActivator.log((IStatus)status);
        }
        return true;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }
}

