/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.charts.Messages;
import org.eclipsetrader.ui.internal.charts.Period;
import org.eclipsetrader.ui.internal.charts.PeriodDialog;
import org.eclipsetrader.ui.internal.charts.PeriodList;

public class ChartPeriodsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ListViewer viewer;
    private Button add;
    private Button edit;
    private Button remove;
    private PeriodList list = new PeriodList();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(UIActivator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(2);
        content.setLayout((Layout)gridLayout);
        this.viewer = new ListViewer(content, 2050);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Period)element).getDescription();
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Period p1 = (Period)e1;
                Period p2 = (Period)e2;
                if (p1.getPeriod().higherThan(p2.getPeriod())) {
                    return -1;
                }
                if (p2.getPeriod().higherThan(p1.getPeriod())) {
                    return 1;
                }
                return 0;
            }
        });
        this.viewer.setInput((Object)this.list);
        Composite buttons = new Composite(content, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.add = new Button(buttons, 8);
        this.add.setText(Messages.ChartPeriodsPreferencePage_Add);
        this.add.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeriodDialog dlg = new PeriodDialog(ChartPeriodsPreferencePage.this.getShell());
                if (dlg.open() == 0) {
                    ChartPeriodsPreferencePage.this.list.add(dlg.getSelection());
                    ChartPeriodsPreferencePage.this.viewer.refresh();
                }
            }
        });
        this.edit = new Button(buttons, 8);
        this.edit.setText(Messages.ChartPeriodsPreferencePage_Edit);
        this.edit.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChartPeriodsPreferencePage.this.viewer.getSelection();
                if (selection.size() != 1) {
                    return;
                }
                Period period = (Period)selection.getFirstElement();
                PeriodDialog dlg = new PeriodDialog(ChartPeriodsPreferencePage.this.getShell(), period);
                if (dlg.open() == 0) {
                    ChartPeriodsPreferencePage.this.viewer.refresh();
                }
            }
        });
        this.edit.setEnabled(false);
        this.remove = new Button(buttons, 8);
        this.remove.setText(Messages.ChartPeriodsPreferencePage_Remove);
        this.remove.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChartPeriodsPreferencePage.this.viewer.getSelection();
                ChartPeriodsPreferencePage.this.list.removeAll(selection.toList());
                ChartPeriodsPreferencePage.this.viewer.refresh();
            }
        });
        this.remove.setEnabled(false);
        this.performDefaults();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChartPeriodsPreferencePage.this.edit.setEnabled(((IStructuredSelection)event.getSelection()).size() == 1);
                ChartPeriodsPreferencePage.this.remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        return content;
    }

    protected void performDefaults() {
        this.list.clear();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PeriodList.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader stream = new StringReader(this.getPreferenceStore().getString("CHART_PERIODS"));
            this.list.addAll((PeriodList)unmarshaller.unmarshal((Reader)stream));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.viewer.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            StringWriter string = new StringWriter();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.list.getClass()});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)this.list, (Writer)string);
            this.getPreferenceStore().setValue("CHART_PERIODS", string.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.performOk();
    }
}

