/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.charts.Messages;
import org.eclipsetrader.ui.internal.charts.Period;

public class PeriodDialog
extends Dialog {
    private Text description;
    private Spinner periodLength;
    private ComboViewer periodUnits;
    private Spinner resolutionLength;
    private ComboViewer resolutionUnits;
    private Period selection;

    public PeriodDialog(Shell parentShell) {
        super(parentShell);
    }

    public PeriodDialog(Shell parentShell, Period selection) {
        super(parentShell);
        this.selection = selection;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PeriodDialog_Period);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        PeriodDialog.applyDialogFont((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.PeriodDialog_Description);
        this.description = new Text(composite, 2048);
        this.description.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ((GridData)this.description.getLayoutData()).widthHint = this.convertHorizontalDLUsToPixels(250);
        label = new Label(composite, 0);
        label.setText(Messages.PeriodDialog_Last);
        this.periodLength = new Spinner(composite, 2048);
        this.periodLength.setValues(1, 1, 9999, 0, 1, 1);
        this.periodUnits = new ComboViewer(composite, 12);
        this.periodUnits.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.periodUnits.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.periodUnits.setSorter(new ViewerSorter());
        this.periodUnits.setInput((Object)new Object[]{TimeSpan.Units.Days, TimeSpan.Units.Months, TimeSpan.Units.Years});
        this.periodUnits.setSelection((ISelection)new StructuredSelection((Object)TimeSpan.Units.Years));
        label = new Label(composite, 0);
        label.setText(Messages.PeriodDialog_BarSize);
        this.resolutionLength = new Spinner(composite, 2048);
        this.resolutionLength.setValues(1, 1, 9999, 0, 1, 1);
        this.resolutionUnits = new ComboViewer(composite, 12);
        this.resolutionUnits.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resolutionUnits.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.resolutionUnits.setSorter(new ViewerSorter());
        this.resolutionUnits.setInput((Object)new Object[]{TimeSpan.Units.Minutes, TimeSpan.Units.Days});
        this.resolutionUnits.setSelection((ISelection)new StructuredSelection((Object)TimeSpan.Units.Days));
        if (this.selection != null) {
            this.description.setText(this.selection.getDescription());
            this.periodLength.setSelection(this.selection.getPeriod().getLength());
            this.periodUnits.setSelection((ISelection)new StructuredSelection((Object)this.selection.getPeriod().getUnits()));
            this.resolutionLength.setSelection(this.selection.getResolution().getLength());
            this.resolutionUnits.setSelection((ISelection)new StructuredSelection((Object)this.selection.getResolution().getUnits()));
        }
        this.resolutionUnits.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TimeSpan.Units units = (TimeSpan.Units)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (units == TimeSpan.Units.Days) {
                    PeriodDialog.this.resolutionLength.setValues(1, 1, 1, 0, 1, 1);
                } else {
                    PeriodDialog.this.resolutionLength.setValues(1, 1, 9999, 0, 1, 1);
                }
            }
        });
        return composite;
    }

    protected void okPressed() {
        TimeSpan period = new TimeSpan((TimeSpan.Units)((IStructuredSelection)this.periodUnits.getSelection()).getFirstElement(), this.periodLength.getSelection());
        TimeSpan barSize = new TimeSpan((TimeSpan.Units)((IStructuredSelection)this.resolutionUnits.getSelection()).getFirstElement(), this.resolutionLength.getSelection());
        if (this.selection == null) {
            this.selection = new Period(this.description.getText(), period, barSize);
        } else {
            this.selection.setDescription(this.description.getText());
            this.selection.setPeriod(period);
            this.selection.setResolution(barSize);
        }
        super.okPressed();
    }

    public Period getSelection() {
        return this.selection;
    }
}

