/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts;

import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipsetrader.core.charts.DataSeries;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.HistogramBarChart;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;

public class VOLUME
implements IChartObjectFactory,
IExecutableExtension {
    private String id;
    private String name;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IChartObject createObject(IDataSeries source) {
        if (source != null) {
            IAdaptable[] sourceValues = source.getValues();
            IAdaptable[] values = new ValueWrapper[sourceValues.length];
            int i = 0;
            while (i < values.length) {
                values[i] = new ValueWrapper((IOHLC)sourceValues[i].getAdapter(IOHLC.class));
                ++i;
            }
            DataSeries result = new DataSeries(this.getName(), values);
            return new HistogramBarChart((IDataSeries)result);
        }
        return null;
    }

    @Override
    public IChartParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.name;
    }

    private static class ValueWrapper
    implements IAdaptable {
        private IOHLC ohlc;

        public ValueWrapper(IOHLC ohlc) {
            this.ohlc = ohlc;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(Date.class)) {
                return this.ohlc.getDate();
            }
            if (adapter.isAssignableFrom(Number.class)) {
                return this.ohlc.getVolume();
            }
            if (adapter.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }
    }
}

