/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.tools;

import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipsetrader.core.charts.DataSeries;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.ChartToolEditor;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.IEditableChartObject;
import org.eclipsetrader.ui.charts.IGraphics;
import org.eclipsetrader.ui.charts.PixelTools;
import org.eclipsetrader.ui.internal.charts.tools.Messages;

public class LineToolFactory
implements IChartObjectFactory,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private RGB color;
    private boolean extend1;
    private boolean extend2;
    private Value value1;
    private Value value2;
    private LineToolObject object = new LineToolObject();

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.factoryName = config.getAttribute("name");
        this.name = config.getAttribute("name");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Value getValue1() {
        return this.value1;
    }

    public void setValue1(Value value1) {
        this.value1 = value1;
    }

    public Value getValue2() {
        return this.value2;
    }

    public void setValue2(Value value2) {
        this.value2 = value2;
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    public boolean isExtend1() {
        return this.extend1;
    }

    public void setExtend1(boolean extend1) {
        this.extend1 = extend1;
    }

    public boolean isExtend2() {
        return this.extend2;
    }

    public void setExtend2(boolean extend2) {
        this.extend2 = extend2;
    }

    @Override
    public IChartObject createObject(IDataSeries source) {
        return this.object;
    }

    @Override
    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        if (this.value1 != null) {
            parameters.setParameter("d1", this.value1.getDate());
            parameters.setParameter("v1", this.value1.getValue());
        }
        if (this.extend1) {
            parameters.setParameter("extend1", "true");
        }
        if (this.value2 != null) {
            parameters.setParameter("d2", this.value2.getDate());
            parameters.setParameter("v2", this.value2.getValue());
        }
        if (this.extend2) {
            parameters.setParameter("extend2", "true");
        }
        if (this.color != null) {
            parameters.setParameter("color", this.color);
        }
        return parameters;
    }

    @Override
    public void setParameters(IChartParameters parameters) {
        Double v2;
        Double v1;
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        Date d1 = parameters.hasParameter("d1") ? parameters.getDate("d1") : null;
        Double d = v1 = parameters.hasParameter("v1") ? parameters.getDouble("v1") : null;
        if (d1 != null && v1 != null) {
            this.value1 = new Value(d1, v1);
        }
        Date d2 = parameters.hasParameter("d2") ? parameters.getDate("d2") : null;
        Double d3 = v2 = parameters.hasParameter("v2") ? parameters.getDouble("v2") : null;
        if (d2 != null && v2 != null) {
            this.value2 = new Value(d2, v2);
        }
        this.extend1 = "true".equals(parameters.getString("extend1"));
        this.extend2 = "true".equals(parameters.getString("extend2"));
        this.color = parameters.hasParameter("color") ? parameters.getColor("color") : null;
        this.object.invalidate();
    }

    private class LineToolObject
    implements IChartObject,
    IEditableChartObject {
        private Point p1;
        private Point p2;
        private boolean valid;
        private boolean focus;
        private boolean editorActive;
        private Value currentValue;
        private Point p1start;
        private Point p2start;
        private int lastX = -1;
        private int lastY = -1;

        @Override
        public void setDataBounds(DataBounds bounds) {
            this.p2 = null;
            this.p1 = null;
        }

        @Override
        public IDataSeries getDataSeries() {
            return new DataSeries(LineToolFactory.this.name, new IAdaptable[]{LineToolFactory.this.value1, LineToolFactory.this.value2});
        }

        @Override
        public boolean containsPoint(int x, int y) {
            if (this.p1 != null && this.p2 != null) {
                return PixelTools.isPointOnLine(x, y, this.p1.x, this.p1.y, this.p2.x, this.p2.y);
            }
            return false;
        }

        @Override
        public String getToolTip() {
            return Messages.LineToolFactory_Tooltip;
        }

        @Override
        public String getToolTip(int x, int y) {
            return null;
        }

        @Override
        public void handleFocusGained(ChartObjectFocusEvent event) {
            this.focus = true;
        }

        @Override
        public void handleFocusLost(ChartObjectFocusEvent event) {
            this.focus = false;
        }

        protected boolean hasFocus() {
            return this.focus;
        }

        @Override
        public void invalidate() {
            this.valid = false;
        }

        @Override
        public void paint(IGraphics graphics) {
            if (this.editorActive) {
                return;
            }
            if (!(this.valid && this.p1 != null || LineToolFactory.this.value1 == null)) {
                this.p1 = graphics.mapToPoint(LineToolFactory.this.value1.getDate(), LineToolFactory.this.value1.getValue());
            }
            if (!(this.valid && this.p2 != null || LineToolFactory.this.value2 == null)) {
                this.p2 = graphics.mapToPoint(LineToolFactory.this.value2.getDate(), LineToolFactory.this.value2.getValue());
            }
            if (this.p1 != null && this.p2 != null) {
                graphics.pushState();
                graphics.setForegroundColor(LineToolFactory.this.color);
                if (LineToolFactory.this.extend1 || LineToolFactory.this.extend2) {
                    if (LineToolFactory.this.extend1) {
                        this.drawExtendedLine(graphics, this.p2.x, this.p2.y, this.p1.x, this.p1.y);
                    }
                    if (LineToolFactory.this.extend2) {
                        this.drawExtendedLine(graphics, this.p1.x, this.p1.y, this.p2.x, this.p2.y);
                    }
                } else {
                    graphics.drawLine(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
                }
                if (this.hasFocus()) {
                    graphics.setBackgroundColor(graphics.getForegroundColor());
                    graphics.fillRectangle(this.p1.x - 2, this.p1.y - 2, 5, 5);
                    graphics.fillRectangle(this.p2.x - 2, this.p2.y - 2, 5, 5);
                }
                graphics.popState();
                this.valid = true;
            }
        }

        @Override
        public void paintScale(Graphics graphics) {
        }

        @Override
        public boolean isOnDragHandle(int x, int y) {
            if (this.p1 != null && this.p2 != null) {
                return PixelTools.isPointOnLine(x, y, this.p1.x, this.p1.y, this.p2.x, this.p2.y);
            }
            return false;
        }

        @Override
        public boolean isOnEditHandle(int x, int y) {
            if (this.p1 != null && this.p2 != null) {
                if (Math.abs(x - this.p1.x) <= 2 && Math.abs(y - this.p1.y) <= 2) {
                    return true;
                }
                if (Math.abs(x - this.p2.x) <= 2 && Math.abs(y - this.p2.y) <= 2) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void handleMouseDown(ChartToolEditor.ChartObjectEditorEvent e) {
            if (LineToolFactory.this.value1 == null && LineToolFactory.this.value2 == null) {
                LineToolFactory.this.value1 = new Value(e.date, e.value);
                LineToolFactory.this.value2 = new Value(e.date, e.value);
                this.currentValue = LineToolFactory.this.value2;
            } else {
                if (this.p1 == null || this.p2 == null) {
                    this.p1 = e.graphics.mapToPoint(LineToolFactory.this.value1.getDate(), LineToolFactory.this.value1.getValue());
                    this.p2 = e.graphics.mapToPoint(LineToolFactory.this.value2.getDate(), LineToolFactory.this.value2.getValue());
                }
                if (Math.abs(e.x - this.p1.x) <= 2 && Math.abs(e.y - this.p1.y) <= 2) {
                    this.currentValue = LineToolFactory.this.value1;
                } else if (Math.abs(e.x - this.p2.x) <= 2 && Math.abs(e.y - this.p2.y) <= 2) {
                    this.currentValue = LineToolFactory.this.value2;
                } else {
                    this.p1start = this.p1;
                    this.p2start = this.p2;
                    this.lastX = e.x;
                    this.lastY = e.y;
                }
            }
            this.editorActive = true;
        }

        @Override
        public void handleMouseUp(ChartToolEditor.ChartObjectEditorEvent e) {
            this.currentValue = null;
            this.lastX = -1;
            this.lastY = -1;
            this.editorActive = false;
        }

        @Override
        public void handleMouseMove(ChartToolEditor.ChartObjectEditorEvent e) {
            if (this.editorActive && LineToolFactory.this.value1 != null && LineToolFactory.this.value2 != null) {
                if (this.p1 != null && this.p2 != null) {
                    if (LineToolFactory.this.extend1 || LineToolFactory.this.extend2) {
                        e.canvas.redraw();
                    } else {
                        int x = Math.min(this.p1.x, this.p2.x) - 2;
                        int y = Math.min(this.p1.y, this.p2.y) - 2;
                        int width = Math.abs(this.p2.x - this.p1.x) + 5;
                        int height = Math.abs(this.p2.y - this.p1.y) + 5;
                        e.canvas.redraw(x, y, width, height, false);
                    }
                    e.canvas.update();
                }
                if (this.currentValue != null) {
                    this.currentValue.setDate(e.date);
                    this.currentValue.setValue(e.value);
                } else {
                    LineToolFactory.this.value1.setDate((Date)e.graphics.mapToHorizontalValue(this.p1start.x + e.x - this.lastX));
                    LineToolFactory.this.value1.setValue((Number)e.graphics.mapToVerticalValue(this.p1start.y + e.y - this.lastY));
                    LineToolFactory.this.value2.setDate((Date)e.graphics.mapToHorizontalValue(this.p2start.x + e.x - this.lastX));
                    LineToolFactory.this.value2.setValue((Number)e.graphics.mapToVerticalValue(this.p2start.y + e.y - this.lastY));
                }
                this.p1 = e.graphics.mapToPoint(LineToolFactory.this.value1.getDate(), LineToolFactory.this.value1.getValue());
                this.p2 = e.graphics.mapToPoint(LineToolFactory.this.value2.getDate(), LineToolFactory.this.value2.getValue());
                e.graphics.setForegroundColor(LineToolFactory.this.color);
                if (LineToolFactory.this.extend1 || LineToolFactory.this.extend2) {
                    if (LineToolFactory.this.extend1) {
                        this.drawExtendedLine(e.graphics, this.p2.x, this.p2.y, this.p1.x, this.p1.y);
                    }
                    if (LineToolFactory.this.extend2) {
                        this.drawExtendedLine(e.graphics, this.p1.x, this.p1.y, this.p2.x, this.p2.y);
                    }
                } else {
                    e.graphics.drawLine(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
                }
                if (this.hasFocus()) {
                    e.graphics.setBackgroundColor(e.graphics.getForegroundColor());
                    e.graphics.fillRectangle(this.p1.x - 2, this.p1.y - 2, 5, 5);
                    e.graphics.fillRectangle(this.p2.x - 2, this.p2.y - 2, 5, 5);
                }
            }
        }

        @Override
        public void accept(IChartObjectVisitor visitor) {
            visitor.visit(this);
        }

        private void drawExtendedLine(IGraphics graphics, int x, int y, int x2, int y2) {
            int ydiff = y - y2;
            int xdiff = x2 - x;
            graphics.drawLine(x, y, x2, y2);
            Rectangle bounds = graphics.getBounds();
            if (xdiff != 0 || ydiff != 0) {
                while (x2 > 0 && x2 < bounds.width && y2 > 0 && y2 < bounds.height) {
                    x = x2;
                    y = y2;
                    graphics.drawLine(x, y, x2 += xdiff, y2 -= ydiff);
                }
            }
        }
    }

    public static class Value
    implements IAdaptable {
        private Date date;
        private Number value;

        public Value(Date date, Number value) {
            this.date = date;
            this.value = value;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Number getValue() {
            return this.value;
        }

        public void setValue(Number value) {
            this.value = value;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(Date.class)) {
                return this.date;
            }
            if (adapter.isAssignableFrom(Number.class)) {
                return this.value;
            }
            return null;
        }
    }
}

