/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.IBook;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.markets.MarketPricingEnvironment;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.charts.views.CurrentBook;
import org.eclipsetrader.ui.internal.charts.views.Messages;

public class CurrentBookFactory
implements IChartObjectFactory {
    private ISecurity security;
    private MarketPricingEnvironment pricingEnvironment;
    private CurrentBook object = new CurrentBook();
    private IPricingListener pricingListener = new IPricingListener(){

        public void pricingUpdate(PricingEvent event) {
            if (!event.getSecurity().equals(CurrentBookFactory.this.security)) {
                return;
            }
            PricingDelta[] pricingDeltaArray = event.getDelta();
            int n = pricingDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                PricingDelta delta = pricingDeltaArray[n2];
                if (delta.getNewValue() instanceof IBook) {
                    CurrentBookFactory.this.object.setBook((IBook)delta.getNewValue());
                }
                if (delta.getNewValue() instanceof ITrade) {
                    CurrentBookFactory.this.object.setTrade((ITrade)delta.getNewValue());
                }
                ++n2;
            }
        }
    };

    public CurrentBookFactory() {
        IMarketService marketService = UIActivator.getDefault().getMarketService();
        this.pricingEnvironment = new MarketPricingEnvironment(marketService);
        this.pricingEnvironment.addPricingListener(this.pricingListener);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public String getName() {
        return Messages.CurrentBookFactory_Name;
    }

    @Override
    public IChartObject createObject(IDataSeries source) {
        return this.object;
    }

    @Override
    public IChartParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IChartParameters parameters) {
    }

    public void setSecurity(ISecurity security) {
        this.security = security;
    }

    public void setEnable(boolean enable) {
        if (enable) {
            this.pricingEnvironment.addSecurity(this.security);
            this.pricingEnvironment.addLevel2Security(this.security);
            ITrade trade = this.pricingEnvironment.getTrade(this.security);
            IBook book = this.pricingEnvironment.getBook(this.security);
            this.object.setTrade(trade);
            this.object.setBook(book);
        } else {
            this.pricingEnvironment.removeLevel2Security(this.security);
            this.pricingEnvironment.removeSecurity(this.security);
            this.object.setBook(null);
        }
    }

    public void dispose() {
        this.pricingEnvironment.dispose();
    }
}

