/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.text.NumberFormat;
import java.util.Observable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IGraphics;

public class CurrentPriceLine
extends Observable
implements IChartObject,
IAdaptable {
    private ITrade trade;
    private RGB foreground = Display.getDefault().getSystemColor(28).getRGB();
    private RGB background = Display.getDefault().getSystemColor(29).getRGB();
    private int width;
    private NumberFormat numberFormat = NumberFormat.getInstance();

    public CurrentPriceLine() {
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumIntegerDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(4);
    }

    public void setTrade(ITrade trade) {
        this.trade = trade;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void accept(IChartObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return false;
    }

    @Override
    public IDataSeries getDataSeries() {
        return null;
    }

    @Override
    public String getToolTip() {
        return null;
    }

    @Override
    public String getToolTip(int x, int y) {
        return null;
    }

    @Override
    public void handleFocusGained(ChartObjectFocusEvent event) {
    }

    @Override
    public void handleFocusLost(ChartObjectFocusEvent event) {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void paint(IGraphics graphics) {
        if (this.trade == null || this.trade.getPrice() == null) {
            return;
        }
        graphics.setForegroundColor(this.foreground);
        graphics.setBackgroundColor(this.background);
        int y = graphics.mapToVerticalAxis(this.trade.getPrice());
        graphics.drawLine(0, y, this.width, y);
    }

    @Override
    public void paintScale(Graphics graphics) {
        if (this.trade == null || this.trade.getPrice() == null) {
            return;
        }
        graphics.setForegroundColor(this.foreground);
        graphics.setBackgroundColor(this.background);
        String text = this.numberFormat.format(this.trade.getPrice());
        Point extents = graphics.stringExtent(text);
        int y = graphics.mapToVerticalAxis(this.trade.getPrice()) - extents.y / 2;
        graphics.fillRectangle(0, y, extents.x, extents.y);
        graphics.drawString(text, 0, y);
    }

    @Override
    public void setDataBounds(DataBounds bounds) {
        this.width = bounds.width;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }
}

