/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.CellEditorValueProperty;
import org.eclipsetrader.ui.Util;
import org.eclipsetrader.ui.internal.charts.views.DataViewerLabelProvider;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataDetailEditorModel;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataEditorModel;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataElement;
import org.eclipsetrader.ui.internal.charts.views.Messages;

public class HistoryDataDetailEditor {
    public static final String PROP_DIRTY = "dirty";
    private final HistoryDataDetailEditorModel model;
    private final DataBindingContext dbc;
    private TreeViewer viewer;
    private boolean dirty;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final PropertyChangeListener dirtyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeSupport propertyChangeSupport = HistoryDataDetailEditor.this.changeSupport;
            boolean bl = HistoryDataDetailEditor.this.dirty;
            HistoryDataDetailEditor.this.dirty = true;
            propertyChangeSupport.firePropertyChange(HistoryDataDetailEditor.PROP_DIRTY, bl, true);
        }
    };

    public HistoryDataDetailEditor(Composite parent) {
        this.dbc = new DataBindingContext();
        this.model = new HistoryDataDetailEditorModel();
        this.model.addPropertyChangeListener(this.dirtyChangeListener);
        this.createViewer(parent);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    void createViewer(Composite parent) {
        Tree tree = new Tree(parent, 65538);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer = new TreeViewer(tree);
        IObservableFactory observableFactory = new IObservableFactory(){

            public IObservable createObservable(Object target) {
                if (target instanceof HistoryDataDetailEditorModel) {
                    return Observables.unmodifiableObservableList((IObservableList)((HistoryDataDetailEditorModel)target).getList());
                }
                if (target instanceof HistoryDataEditorModel) {
                    return Observables.unmodifiableObservableList((IObservableList)((HistoryDataEditorModel)target).getList());
                }
                return null;
            }
        };
        TreeStructureAdvisor treeStructureAdvisor = new TreeStructureAdvisor(){

            public Boolean hasChildren(Object element) {
                if (element instanceof HistoryDataEditorModel) {
                    return true;
                }
                return false;
            }
        };
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(observableFactory, treeStructureAdvisor);
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        GC gc = new GC((Drawable)parent);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.viewer, 0);
        viewerColumn.getColumn().setText(Messages.HistoryDataDetailEditor_Time);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)70));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)tree), (IValueProperty)CellEditorValueProperty.timeValue(), (IValueProperty)BeanProperties.value((String)"date")));
        viewerColumn = new TreeViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.HistoryDataDetailEditor_Open);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)55));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)tree), (IValueProperty)CellEditorValueProperty.doubleValue(), (IValueProperty)BeanProperties.value((String)"open")));
        viewerColumn = new TreeViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.HistoryDataDetailEditor_High);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)55));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)tree), (IValueProperty)CellEditorValueProperty.doubleValue(), (IValueProperty)BeanProperties.value((String)"high")));
        viewerColumn = new TreeViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.HistoryDataDetailEditor_Low);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)55));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)tree), (IValueProperty)CellEditorValueProperty.doubleValue(), (IValueProperty)BeanProperties.value((String)"low")));
        viewerColumn = new TreeViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.HistoryDataDetailEditor_Close);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)55));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)tree), (IValueProperty)CellEditorValueProperty.doubleValue(), (IValueProperty)BeanProperties.value((String)"close")));
        viewerColumn = new TreeViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.HistoryDataDetailEditor_Volume);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)70));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)tree), (IValueProperty)CellEditorValueProperty.longValue(), (IValueProperty)BeanProperties.value((String)"volume")));
        if ("gtk".equals(Platform.getWS())) {
            viewerColumn = new TreeViewerColumn(this.viewer, 131072);
            viewerColumn.getColumn().setWidth(1);
        }
        final String[] properties = new String[]{"date", "open", "high", "low", "close", "volume", ""};
        DataViewerLabelProvider labelProvider = new DataViewerLabelProvider(BeansObservables.observeMaps((IObservableSet)contentProvider.getKnownElements(), (String[])properties));
        labelProvider.setDateFormat(Util.getTimeFormat());
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 instanceof HistoryDataEditorModel && o2 instanceof HistoryDataEditorModel) {
                    TimeSpan ts2;
                    TimeSpan ts1 = ((HistoryDataEditorModel)o1).getBarSize();
                    if (ts1.higherThan(ts2 = ((HistoryDataEditorModel)o2).getBarSize())) {
                        return 1;
                    }
                    if (ts2.higherThan(ts1)) {
                        return -1;
                    }
                    return 0;
                }
                if (o1 instanceof HistoryDataElement && o2 instanceof HistoryDataElement) {
                    HistoryDataElement e1 = (HistoryDataElement)o1;
                    HistoryDataElement e2 = (HistoryDataElement)o2;
                    if (e1.getDate() != null && e2.getDate() != null) {
                        return e1.getDate().compareTo(e2.getDate());
                    }
                    if (e1.getDate() != null && e2.getDate() == null) {
                        return -1;
                    }
                    if (e1.getDate() == null && e2.getDate() != null) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        CellNavigationStrategy naviStrat = new CellNavigationStrategy(){

            public ViewerCell findSelectedCell(ColumnViewer viewer, ViewerCell currentSelectedCell, Event event) {
                ViewerCell cell = super.findSelectedCell(viewer, currentSelectedCell, event);
                if (cell != null) {
                    if (cell.getColumnIndex() == properties.length - 1) {
                        return null;
                    }
                    Tree tree = ((TreeViewer)viewer).getTree();
                    tree.showColumn(tree.getColumn(cell.getColumnIndex()));
                }
                return cell;
            }
        };
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer), naviStrat);
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TreeViewerEditor.create((TreeViewer)this.viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)58);
        tree.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 || e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (HistoryDataDetailEditor.this.viewer.isCellEditorActive()) {
                    return;
                }
                if (e.keyCode == 0x1000009) {
                    IStructuredSelection selection = (IStructuredSelection)HistoryDataDetailEditor.this.viewer.getSelection();
                    HistoryDataEditorModel parent = null;
                    int index = 0;
                    if (!selection.isEmpty()) {
                        parent = HistoryDataDetailEditor.this.model.getParent(selection.getFirstElement());
                        if (parent == null) {
                            return;
                        }
                        index = parent.getList().indexOf(selection.getFirstElement());
                        if (index == -1) {
                            index = parent.getList().size();
                        }
                    }
                    final HistoryDataElement element = new HistoryDataElement();
                    parent.getList().add(index, (Object)element);
                    e.doit = false;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!HistoryDataDetailEditor.this.viewer.getControl().isDisposed()) {
                                HistoryDataDetailEditor.this.viewer.editElement((Object)element, 0);
                            }
                        }
                    });
                } else if (e.character == '\u007f') {
                    IStructuredSelection selection = (IStructuredSelection)HistoryDataDetailEditor.this.viewer.getSelection();
                    for (Object element : selection.toList()) {
                        HistoryDataEditorModel parent = HistoryDataDetailEditor.this.model.getParent(selection.getFirstElement());
                        if (parent == null || !parent.getList().remove(element)) continue;
                        PropertyChangeSupport propertyChangeSupport = HistoryDataDetailEditor.this.changeSupport;
                        boolean bl = HistoryDataDetailEditor.this.dirty;
                        HistoryDataDetailEditor.this.dirty = true;
                        propertyChangeSupport.firePropertyChange(HistoryDataDetailEditor.PROP_DIRTY, bl, true);
                    }
                }
            }
        });
        this.viewer.setInput((Object)this.model);
    }

    public void load(IHistory history, Date date) {
        IHistory[] childHistory = history.getDay(date);
        this.model.set(childHistory);
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public HistoryDataDetailEditorModel getModel() {
        return this.model;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        PropertyChangeListener[] listeners = this.changeSupport.getPropertyChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            this.changeSupport.removePropertyChangeListener(listeners[i]);
            ++i;
        }
        this.viewer.getControl().dispose();
        this.model.dispose();
        this.dbc.dispose();
    }
}

