/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.ui.CellEditorValueProperty;
import org.eclipsetrader.ui.Util;
import org.eclipsetrader.ui.internal.charts.views.ChartLoadJob;
import org.eclipsetrader.ui.internal.charts.views.DataViewerLabelProvider;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataEditorModel;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataElement;
import org.eclipsetrader.ui.internal.charts.views.Messages;

public class HistoryDataEditor {
    public static final String PROP_DIRTY = "dirty";
    private final HistoryDataEditorModel model;
    private final DataBindingContext dbc;
    private TableViewer viewer;
    private IHistory history;
    private boolean dirty;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final PropertyChangeListener dirtyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeSupport propertyChangeSupport = HistoryDataEditor.this.changeSupport;
            boolean bl = HistoryDataEditor.this.dirty;
            HistoryDataEditor.this.dirty = true;
            propertyChangeSupport.firePropertyChange(HistoryDataEditor.PROP_DIRTY, bl, true);
        }
    };
    private final IListChangeListener listChangeListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            event.diff.accept(new ListDiffVisitor(){

                public void handleRemove(int index, Object element) {
                    ((HistoryDataElement)element).removePropertyChangeListener(HistoryDataEditor.this.dirtyChangeListener);
                }

                public void handleAdd(int index, Object element) {
                    ((HistoryDataElement)element).addPropertyChangeListener(HistoryDataEditor.this.dirtyChangeListener);
                }
            });
        }
    };
    private final PropertyChangeListener dataChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("bars".equals(evt.getPropertyName())) {
                final IOHLC[] newBars = (IOHLC[])evt.getNewValue();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (HistoryDataEditor.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        HistoryDataEditor.this.model.merge(newBars);
                    }
                });
            }
        }
    };

    public HistoryDataEditor(Composite parent) {
        this.dbc = new DataBindingContext();
        this.model = new HistoryDataEditorModel(TimeSpan.days((int)1));
        this.model.getList().addListChangeListener(this.listChangeListener);
        this.createViewer(parent);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    void createViewer(Composite parent) {
        Table table = new Table(parent, 65538);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        GC gc = new GC((Drawable)parent);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        viewerColumn.getColumn().setText(Messages.HistoryDataEditor_Date);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)70));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)table), (IValueProperty)CellEditorValueProperty.dateValue(), (IValueProperty)BeanProperties.value((String)"date")));
        viewerColumn = new TableViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.HistoryDataEditor_Open);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)55));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)table), (IValueProperty)CellEditorValueProperty.doubleValue(), (IValueProperty)BeanProperties.value((String)"open")));
        viewerColumn = new TableViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.HistoryDataEditor_High);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)55));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)table), (IValueProperty)CellEditorValueProperty.doubleValue(), (IValueProperty)BeanProperties.value((String)"high")));
        viewerColumn = new TableViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.HistoryDataEditor_Low);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)55));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)table), (IValueProperty)CellEditorValueProperty.doubleValue(), (IValueProperty)BeanProperties.value((String)"low")));
        viewerColumn = new TableViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.HistoryDataEditor_Close);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)55));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)table), (IValueProperty)CellEditorValueProperty.doubleValue(), (IValueProperty)BeanProperties.value((String)"close")));
        viewerColumn = new TableViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.HistoryDataEditor_Volume);
        viewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)70));
        viewerColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.viewer, (DataBindingContext)this.dbc, (CellEditor)new TextCellEditor((Composite)table), (IValueProperty)CellEditorValueProperty.longValue(), (IValueProperty)BeanProperties.value((String)"volume")));
        if ("gtk".equals(Platform.getWS())) {
            viewerColumn = new TableViewerColumn(this.viewer, 131072);
            viewerColumn.getColumn().setWidth(1);
        }
        final String[] properties = new String[]{"date", "open", "high", "low", "close", "volume", ""};
        DataViewerLabelProvider labelProvider = new DataViewerLabelProvider(BeansObservables.observeMaps((IObservableSet)contentProvider.getKnownElements(), (String[])properties));
        labelProvider.setDateFormat(Util.getDateFormat());
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                HistoryDataElement e1 = (HistoryDataElement)o1;
                HistoryDataElement e2 = (HistoryDataElement)o2;
                if (e1.getDate() != null && e2.getDate() != null) {
                    return e1.getDate().compareTo(e2.getDate());
                }
                if (e1.getDate() != null && e2.getDate() == null) {
                    return -1;
                }
                if (e1.getDate() == null && e2.getDate() != null) {
                    return 1;
                }
                return 0;
            }
        });
        CellNavigationStrategy naviStrat = new CellNavigationStrategy(){

            public ViewerCell findSelectedCell(ColumnViewer viewer, ViewerCell currentSelectedCell, Event event) {
                ViewerCell cell = super.findSelectedCell(viewer, currentSelectedCell, event);
                if (cell != null) {
                    if (cell.getColumnIndex() == properties.length - 1) {
                        return null;
                    }
                    Table table = ((TableViewer)viewer).getTable();
                    table.showColumn(table.getColumn(cell.getColumnIndex()));
                }
                return cell;
            }
        };
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer), naviStrat);
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)58);
        table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 || e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (HistoryDataEditor.this.viewer.isCellEditorActive()) {
                    return;
                }
                if (e.keyCode == 0x1000009) {
                    IStructuredSelection selection = (IStructuredSelection)HistoryDataEditor.this.viewer.getSelection();
                    int index = 0;
                    if (!selection.isEmpty() && (index = HistoryDataEditor.this.model.getList().indexOf(selection.getFirstElement())) == -1) {
                        index = HistoryDataEditor.this.model.getList().size();
                    }
                    final HistoryDataElement element = new HistoryDataElement();
                    HistoryDataEditor.this.model.getList().add(index, (Object)element);
                    e.doit = false;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!HistoryDataEditor.this.viewer.getControl().isDisposed()) {
                                HistoryDataEditor.this.viewer.editElement((Object)element, 0);
                            }
                        }
                    });
                } else if (e.character == '\u007f') {
                    IStructuredSelection selection = (IStructuredSelection)HistoryDataEditor.this.viewer.getSelection();
                    if (HistoryDataEditor.this.model.getList().removeAll((Collection)selection.toList())) {
                        PropertyChangeSupport propertyChangeSupport = HistoryDataEditor.this.changeSupport;
                        boolean bl = HistoryDataEditor.this.dirty;
                        HistoryDataEditor.this.dirty = true;
                        propertyChangeSupport.firePropertyChange(HistoryDataEditor.PROP_DIRTY, bl, true);
                    }
                }
            }
        });
        this.viewer.setInput((Object)this.model.getList());
    }

    public void load(ISecurity security) {
        PropertyChangeSupport propertyChangeSupport;
        if (this.history != null && (propertyChangeSupport = (PropertyChangeSupport)this.history.getAdapter(PropertyChangeSupport.class)) != null) {
            propertyChangeSupport.removePropertyChangeListener(this.dataChangeListener);
        }
        ChartLoadJob job = new ChartLoadJob(security);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ChartLoadJob job = (ChartLoadJob)event.getJob();
                HistoryDataEditor.this.history = job.getHistory();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        HistoryDataEditor.this.model.set(HistoryDataEditor.this.history.getOHLC());
                        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)HistoryDataEditor.this.history.getAdapter(PropertyChangeSupport.class);
                        if (propertyChangeSupport != null) {
                            propertyChangeSupport.addPropertyChangeListener(HistoryDataEditor.this.dataChangeListener);
                        }
                    }
                });
            }
        });
        job.setResolutionTimeSpan(TimeSpan.days((int)1));
        job.setName(NLS.bind((String)Messages.HistoryDataEditor_LoadingHistory, (Object[])new Object[]{security.getName()}));
        job.setUser(true);
        job.schedule();
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public HistoryDataEditorModel getModel() {
        return this.model;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public IHistory getHistory() {
        return this.history;
    }

    public void dispose() {
        PropertyChangeSupport propertyChangeSupport;
        if (this.history != null && (propertyChangeSupport = (PropertyChangeSupport)this.history.getAdapter(PropertyChangeSupport.class)) != null) {
            propertyChangeSupport.removePropertyChangeListener(this.dataChangeListener);
        }
        PropertyChangeListener[] listeners = this.changeSupport.getPropertyChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            this.changeSupport.removePropertyChangeListener(listeners[i]);
            ++i;
        }
        this.viewer.getControl().dispose();
        this.model.getList().removeListChangeListener(this.listChangeListener);
        this.model.dispose();
        this.dbc.dispose();
    }
}

