/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataElement;

public class HistoryDataEditorModel {
    private final TimeSpan barSize;
    private final WritableList list = new WritableList();
    private HistoryDataElement lastElement;
    private final PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            HistoryDataElement element = (HistoryDataElement)evt.getSource();
            if (element.isEmpty()) {
                if (element != HistoryDataEditorModel.this.lastElement) {
                    HistoryDataEditorModel.this.list.remove((Object)element);
                }
            } else if (element == HistoryDataEditorModel.this.lastElement) {
                WritableList writableList = HistoryDataEditorModel.this.list;
                HistoryDataElement historyDataElement = new HistoryDataElement();
                HistoryDataEditorModel.this.lastElement = historyDataElement;
                writableList.add((Object)historyDataElement);
            }
        }
    };
    private final IListChangeListener listChangeListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            event.diff.accept(new ListDiffVisitor(){

                public void handleRemove(int index, Object element) {
                    ((HistoryDataElement)element).removePropertyChangeListener(HistoryDataEditorModel.this.changeListener);
                }

                public void handleAdd(int index, Object element) {
                    ((HistoryDataElement)element).addPropertyChangeListener(HistoryDataEditorModel.this.changeListener);
                }
            });
        }
    };

    public HistoryDataEditorModel(TimeSpan barSize) {
        this.barSize = barSize;
        this.list.addListChangeListener(this.listChangeListener);
        this.lastElement = new HistoryDataElement();
        this.list.add((Object)this.lastElement);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public void dispose() {
        this.list.removeListChangeListener(this.listChangeListener);
    }

    public void set(IOHLC[] ohlc) {
        this.list.clear();
        ArrayList<HistoryDataElement> l = new ArrayList<HistoryDataElement>();
        int i = 0;
        while (i < ohlc.length) {
            l.add(new HistoryDataElement(ohlc[i]));
            ++i;
        }
        this.list.addAll(l);
        this.lastElement = new HistoryDataElement();
        this.list.add((Object)this.lastElement);
    }

    public void merge(IOHLC[] ohlc) {
        HashMap<Date, HistoryDataElement> map = new HashMap<Date, HistoryDataElement>();
        for (Object o : this.list) {
            Date date = ((HistoryDataElement)o).getDate();
            if (date == null) continue;
            map.put(date, (HistoryDataElement)o);
        }
        int i = 0;
        while (i < ohlc.length) {
            HistoryDataElement oldElement = (HistoryDataElement)map.get(ohlc[i].getDate());
            if (oldElement != null) {
                if (!oldElement.equalsTo(ohlc[i])) {
                    int index = this.list.indexOf((Object)oldElement);
                    this.list.set(index, (Object)new HistoryDataElement(ohlc[i]));
                }
            } else {
                this.list.add((Object)new HistoryDataElement(ohlc[i]));
            }
            ++i;
        }
    }

    public IOHLC[] toOHLC() {
        ArrayList<IOHLC> l = new ArrayList<IOHLC>();
        for (Object o : this.list) {
            HistoryDataElement element = (HistoryDataElement)o;
            if (!element.isValid()) continue;
            l.add(element.toOHLC());
        }
        return l.toArray(new IOHLC[l.size()]);
    }

    public WritableList getList() {
        return this.list;
    }

    public TimeSpan getBarSize() {
        return this.barSize;
    }

    public String getDate() {
        return this.barSize.getDescription();
    }

    public HistoryDataElement getLastElement() {
        return this.lastElement;
    }
}

