/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.feed.History;
import org.eclipsetrader.core.feed.HistoryDay;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.Util;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.charts.DataImportJob;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataDetailEditor;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataDetailEditorModel;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataEditor;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataEditorModel;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataElement;
import org.eclipsetrader.ui.internal.charts.views.Messages;

public class HistoryDataEditorPart
extends ViewPart
implements ISaveablePart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.editors.history";
    public static final String K_VIEWS = "Views";
    public static final String K_URI = "uri";
    private URI uri;
    private ISecurity security;
    private Composite stackContainer;
    private StackLayout stackLayout;
    private MenuManager contextMenuManager;
    private HistoryDataEditor editor;
    private final Map<Date, HistoryDataDetailEditor> editorMap = new HashMap<Date, HistoryDataDetailEditor>();
    private Action updateAction;
    private Action editAction;
    private Action goIntoAction;
    private Action backUpAction;
    private IDialogSettings dialogSettings;
    private boolean dirty;
    private final PropertyChangeListener dirtyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!HistoryDataEditorPart.this.dirty) {
                HistoryDataEditorPart.this.dirty = true;
                HistoryDataEditorPart.this.firePropertyChange(257);
            }
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        try {
            this.dialogSettings = UIActivator.getDefault().getDialogSettings().getSection(K_VIEWS).getSection(site.getSecondaryId());
            this.uri = new URI(this.dialogSettings.get(K_URI));
            IRepositoryService repositoryService = UIActivator.getDefault().getRepositoryService();
            this.security = repositoryService.getSecurityFromURI(this.uri);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", String.valueOf(Messages.ChartViewPart_LoadingErrorMessage) + site.getSecondaryId(), (Throwable)e);
            UIActivator.log((IStatus)status);
        }
        this.createActions();
        IActionBars actionBars = site.getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)this.goIntoAction);
        toolBarManager.add((IAction)this.backUpAction);
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IAction)this.updateAction);
    }

    protected void createActions() {
        this.updateAction = new Action(Messages.ChartViewPart_UpdateAction){

            public void run() {
                DataImportJob job = new DataImportJob(HistoryDataEditorPart.this.security, 1, null, null, new TimeSpan[]{TimeSpan.days((int)1), TimeSpan.minutes((int)1), TimeSpan.minutes((int)2), TimeSpan.minutes((int)3), TimeSpan.minutes((int)5), TimeSpan.minutes((int)10), TimeSpan.minutes((int)15), TimeSpan.minutes((int)30)});
                job.setUser(true);
                job.schedule();
            }
        };
        this.updateAction.setId("update");
        this.updateAction.setImageDescriptor(UIActivator.imageDescriptorFromPlugin("icons/etool16/refresh.gif"));
        this.updateAction.setEnabled(true);
        this.editAction = new Action(Messages.HistoryDataEditorPart_Edit){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)HistoryDataEditorPart.this.editor.getViewer().getSelection();
                if (selection.size() != 1) {
                    return;
                }
                final Object element = selection.getFirstElement();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!HistoryDataEditorPart.this.editor.getControl().isDisposed()) {
                            HistoryDataEditorPart.this.editor.getViewer().editElement(element, 0);
                        }
                    }
                });
            }
        };
        this.editAction.setEnabled(true);
        this.goIntoAction = new Action(Messages.HistoryDataEditorPart_ZoomIn){

            public void run() {
                if (((HistoryDataEditorPart)HistoryDataEditorPart.this).stackLayout.topControl == HistoryDataEditorPart.this.editor.getControl()) {
                    HistoryDataEditorPart.this.goInto();
                }
            }
        };
        this.goIntoAction.setImageDescriptor(UIActivator.getImageDescriptor("icons/elcl16/zoom_in.png"));
        this.goIntoAction.setEnabled(false);
        this.backUpAction = new Action(Messages.HistoryDataEditorPart_ZoomOut){

            public void run() {
                if (((HistoryDataEditorPart)HistoryDataEditorPart.this).stackLayout.topControl != HistoryDataEditorPart.this.editor.getControl()) {
                    HistoryDataEditorPart.this.setContentDescription("");
                    ((HistoryDataEditorPart)HistoryDataEditorPart.this).stackLayout.topControl = HistoryDataEditorPart.this.editor.getControl();
                    HistoryDataEditorPart.this.stackContainer.layout();
                }
                HistoryDataEditorPart.this.goIntoAction.setEnabled(((HistoryDataEditorPart)HistoryDataEditorPart.this).stackLayout.topControl == HistoryDataEditorPart.this.editor.getControl());
                HistoryDataEditorPart.this.backUpAction.setEnabled(((HistoryDataEditorPart)HistoryDataEditorPart.this).stackLayout.topControl != HistoryDataEditorPart.this.editor.getControl());
            }
        };
        this.backUpAction.setImageDescriptor(UIActivator.getImageDescriptor("icons/elcl16/zoom_out.png"));
        this.backUpAction.setEnabled(false);
    }

    public void createPartControl(Composite parent) {
        this.stackContainer = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.stackContainer.setLayout((Layout)this.stackLayout);
        this.editor = new HistoryDataEditor(this.stackContainer);
        this.editor.addPropertyChangeListener(this.dirtyChangeListener);
        this.stackLayout.topControl = this.editor.getControl();
        this.createContextMenu();
        this.editor.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HistoryDataEditorPart.this.goIntoAction.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.editor.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (((HistoryDataEditorPart)HistoryDataEditorPart.this).stackLayout.topControl == HistoryDataEditorPart.this.editor.getControl()) {
                    HistoryDataEditorPart.this.goInto();
                }
            }
        });
        if (this.security != null) {
            this.setPartName(NLS.bind((String)"{0} - {1}", (Object[])new Object[]{this.security.getName(), Messages.HistoryDataEditorPart_History}));
            this.editor.load(this.security);
        }
    }

    void createContextMenu() {
        this.contextMenuManager = new MenuManager("#popupMenu", "popupMenu");
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("group.new"));
                menuManager.add((IContributionItem)new GroupMarker("group.goto"));
                menuManager.add((IContributionItem)new Separator("group.show"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
                menuManager.add((IContributionItem)new GroupMarker("group.port"));
                menuManager.add((IContributionItem)new Separator("group.generate"));
                menuManager.add((IContributionItem)new Separator("group.search"));
                menuManager.add((IContributionItem)new Separator("group.build"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("group.properties"));
                menuManager.appendToGroup("group.goto", (IAction)HistoryDataEditorPart.this.goIntoAction);
                menuManager.appendToGroup("group.goto", (IAction)HistoryDataEditorPart.this.backUpAction);
                menuManager.appendToGroup("group.edit", (IAction)HistoryDataEditorPart.this.editAction);
            }
        });
        this.editor.getViewer().getControl().setMenu(this.contextMenuManager.createContextMenu(this.editor.getViewer().getControl()));
        this.getSite().registerContextMenu(this.contextMenuManager, this.getSite().getSelectionProvider());
    }

    public void setFocus() {
        if (this.stackContainer != null) {
            this.stackContainer.setFocus();
        }
    }

    public void dispose() {
        this.editor.dispose();
        for (HistoryDataDetailEditor treeEditor : this.editorMap.values()) {
            treeEditor.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        final IRepositoryService repository = UIActivator.getDefault().getRepositoryService();
        repository.runInService(new IRepositoryRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                for (HistoryDataDetailEditor treeEditor : HistoryDataEditorPart.this.editorMap.values()) {
                    if (!treeEditor.isDirty()) continue;
                    HistoryDataDetailEditorModel treeModel = treeEditor.getModel();
                    for (Map.Entry<IHistory, HistoryDataEditorModel> entry : treeModel.getMap().entrySet()) {
                        IHistory history = entry.getKey();
                        HistoryDataEditorModel model = entry.getValue();
                        HistoryDay saveableHistory = (HistoryDay)history.getAdapter(HistoryDay.class);
                        if (saveableHistory == null) continue;
                        saveableHistory.setOHLC(model.toOHLC());
                        repository.saveAdaptable(new IAdaptable[]{history});
                        treeEditor.setDirty(false);
                    }
                }
                if (HistoryDataEditorPart.this.editor.isDirty()) {
                    History history = (History)HistoryDataEditorPart.this.editor.getHistory().getAdapter(History.class);
                    if (history != null) {
                        history.setOHLC(HistoryDataEditorPart.this.editor.getModel().toOHLC());
                        repository.saveAdaptable(new IAdaptable[]{history});
                    }
                    HistoryDataEditorPart.this.editor.setDirty(false);
                }
                return Status.OK_STATUS;
            }
        }, monitor);
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.dirty;
    }

    private void goInto() {
        IStructuredSelection selection = (IStructuredSelection)this.editor.getViewer().getSelection();
        if (selection.size() != 1) {
            return;
        }
        final HistoryDataElement element = (HistoryDataElement)selection.getFirstElement();
        if (element.getDate() == null) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                HistoryDataDetailEditor treeEditor = (HistoryDataDetailEditor)HistoryDataEditorPart.this.editorMap.get(element.getDate());
                if (treeEditor == null) {
                    treeEditor = new HistoryDataDetailEditor(HistoryDataEditorPart.this.stackContainer);
                    treeEditor.addPropertyChangeListener(HistoryDataEditorPart.this.dirtyChangeListener);
                    treeEditor.getViewer().getControl().setMenu(HistoryDataEditorPart.this.contextMenuManager.createContextMenu(treeEditor.getViewer().getControl()));
                    treeEditor.load(HistoryDataEditorPart.this.editor.getHistory(), element.getDate());
                    HistoryDataEditorPart.this.editorMap.put(element.getDate(), treeEditor);
                }
                HistoryDataEditorPart.this.setContentDescription(" " + Util.getDateFormat().format(element.getDate()));
                ((HistoryDataEditorPart)HistoryDataEditorPart.this).stackLayout.topControl = treeEditor.getControl();
                HistoryDataEditorPart.this.stackContainer.layout();
                HistoryDataEditorPart.this.goIntoAction.setEnabled(((HistoryDataEditorPart)HistoryDataEditorPart.this).stackLayout.topControl == HistoryDataEditorPart.this.editor.getControl());
                HistoryDataEditorPart.this.backUpAction.setEnabled(((HistoryDataEditorPart)HistoryDataEditorPart.this).stackLayout.topControl != HistoryDataEditorPart.this.editor.getControl());
            }
        });
    }
}

