/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.OHLC;

public class HistoryDataElement {
    public static final String PROP_DATE = "date";
    public static final String PROP_OPEN = "open";
    public static final String PROP_HIGH = "high";
    public static final String PROP_LOW = "low";
    public static final String PROP_CLOSE = "close";
    public static final String PROP_VOLUME = "volume";
    private Date date;
    private Double open;
    private Double high;
    private Double low;
    private Double close;
    private Long volume;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public HistoryDataElement() {
    }

    public HistoryDataElement(IOHLC ohlc) {
        this.date = ohlc.getDate();
        this.open = ohlc.getOpen();
        this.high = ohlc.getHigh();
        this.low = ohlc.getLow();
        this.close = ohlc.getClose();
        this.volume = ohlc.getVolume();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
        this.changeSupport.firePropertyChange(PROP_DATE, this.date, this.date);
    }

    public Double getOpen() {
        return this.open;
    }

    public void setOpen(Double open) {
        this.open = open;
        this.changeSupport.firePropertyChange(PROP_OPEN, this.open, this.open);
    }

    public Double getHigh() {
        return this.high;
    }

    public void setHigh(Double high) {
        this.high = high;
        this.changeSupport.firePropertyChange(PROP_HIGH, this.high, this.high);
    }

    public Double getLow() {
        return this.low;
    }

    public void setLow(Double low) {
        this.low = low;
        this.changeSupport.firePropertyChange(PROP_LOW, this.low, this.low);
    }

    public Double getClose() {
        return this.close;
    }

    public void setClose(Double close) {
        this.close = close;
        this.changeSupport.firePropertyChange(PROP_CLOSE, this.close, this.close);
    }

    public Long getVolume() {
        return this.volume;
    }

    public void setVolume(Long volume) {
        this.volume = volume;
        this.changeSupport.firePropertyChange(PROP_VOLUME, this.volume, this.volume);
    }

    public IOHLC toOHLC() {
        return new OHLC(this.date, this.open, this.high, this.low, this.close, this.volume);
    }

    public boolean isEmpty() {
        return this.date == null && this.open == null && this.high == null && this.low == null && this.close == null && this.volume == null;
    }

    public boolean isValid() {
        return this.date != null && this.open != null && this.high != null && this.low != null && this.close != null && this.volume != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HistoryDataElement)) {
            return false;
        }
        HistoryDataElement other = (HistoryDataElement)obj;
        if (this.date != null && !this.date.equals(other.date) || this.date == null && other.date != null) {
            return false;
        }
        if (this.open != null && !this.open.equals(other.open) || this.open == null && other.open != null) {
            return false;
        }
        if (this.high != null && !this.high.equals(other.high) || this.high == null && other.high != null) {
            return false;
        }
        if (this.low != null && !this.low.equals(other.low) || this.low == null && other.low != null) {
            return false;
        }
        if (this.close != null && !this.close.equals(other.close) || this.close == null && other.close != null) {
            return false;
        }
        return (this.volume == null || this.volume.equals(other.volume)) && (this.volume != null || other.volume == null);
    }

    public boolean equalsTo(IOHLC ohlc) {
        if (this.date != null && !this.date.equals(ohlc.getDate()) || this.date == null && ohlc.getDate() != null) {
            return false;
        }
        if (this.open != null && !this.open.equals(ohlc.getOpen()) || this.open == null && ohlc.getOpen() != null) {
            return false;
        }
        if (this.high != null && !this.high.equals(ohlc.getHigh()) || this.high == null && ohlc.getHigh() != null) {
            return false;
        }
        if (this.low != null && !this.low.equals(ohlc.getLow()) || this.low == null && ohlc.getLow() != null) {
            return false;
        }
        if (this.close != null && !this.close.equals(ohlc.getClose()) || this.close == null && ohlc.getClose() != null) {
            return false;
        }
        return (this.volume == null || this.volume.equals(ohlc.getVolume())) && (this.volume != null || ohlc.getVolume() == null);
    }
}

