/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.OHLCDataSeries;
import org.eclipsetrader.ui.charts.BarChart;
import org.eclipsetrader.ui.charts.CandleStickChart;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.HistogramAreaChart;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.charts.OHLCLineChart;
import org.eclipsetrader.ui.internal.charts.views.MainRenderStyle;

public class MainChartFactory
implements IChartObjectFactory {
    public static final String FACTORY_ID = "org.eclipsetrader.ui.charts.main";
    private MainRenderStyle style = MainRenderStyle.Candles;
    private OHLCField lineField = OHLCField.Close;
    private RGB lineColor;
    private RGB barPositiveColor;
    private RGB barNegativeColor;
    private RGB candlePositiveColor;
    private RGB candleNegativeColor;
    private RGB candleOutlineColor;

    @Override
    public String getId() {
        return FACTORY_ID;
    }

    @Override
    public String getName() {
        return "MAIN";
    }

    public OHLCField getLineField() {
        return this.lineField;
    }

    public void setLineField(OHLCField field) {
        this.lineField = field;
    }

    public MainRenderStyle getStyle() {
        return this.style;
    }

    public void setStyle(MainRenderStyle style) {
        this.style = style;
    }

    public RGB getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(RGB lineColor) {
        this.lineColor = lineColor;
    }

    public RGB getBarPositiveColor() {
        return this.barPositiveColor;
    }

    public void setBarPositiveColor(RGB barPositiveColor) {
        this.barPositiveColor = barPositiveColor;
    }

    public RGB getBarNegativeColor() {
        return this.barNegativeColor;
    }

    public void setBarNegativeColor(RGB barNegativeColor) {
        this.barNegativeColor = barNegativeColor;
    }

    public RGB getCandlePositiveColor() {
        return this.candlePositiveColor;
    }

    public void setCandlePositiveColor(RGB candlePositiveColor) {
        this.candlePositiveColor = candlePositiveColor;
    }

    public RGB getCandleNegativeColor() {
        return this.candleNegativeColor;
    }

    public void setCandleNegativeColor(RGB candleNegativeColor) {
        this.candleNegativeColor = candleNegativeColor;
    }

    public RGB getCandleOutlineColor() {
        return this.candleOutlineColor;
    }

    public void setCandleOutlineColor(RGB candleBorderColor) {
        this.candleOutlineColor = candleBorderColor;
    }

    @Override
    public IChartObject createObject(IDataSeries source) {
        if (source == null || !(source instanceof OHLCDataSeries)) {
            return null;
        }
        if (this.style == MainRenderStyle.Bars) {
            return new BarChart(source, this.barPositiveColor, this.barNegativeColor);
        }
        if (this.style == MainRenderStyle.Candles) {
            return new CandleStickChart(source, this.candleOutlineColor, this.candlePositiveColor, this.candleNegativeColor);
        }
        if (this.style == MainRenderStyle.Histogram) {
            return new HistogramAreaChart(source, this.lineColor);
        }
        return new OHLCLineChart(source, OHLCLineChart.LineStyle.Solid, this.lineColor);
    }

    @Override
    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        parameters.setParameter("style", this.style.getName());
        if (this.lineColor != null) {
            parameters.setParameter("line-color", this.lineColor);
        }
        if (this.barPositiveColor != null) {
            parameters.setParameter("bar-positive-color", this.barPositiveColor);
        }
        if (this.barNegativeColor != null) {
            parameters.setParameter("bar-negative-color", this.barNegativeColor);
        }
        if (this.candlePositiveColor != null) {
            parameters.setParameter("candle-positive-color", this.candlePositiveColor);
        }
        if (this.candleNegativeColor != null) {
            parameters.setParameter("candle-negative-color", this.candleNegativeColor);
        }
        if (this.candleOutlineColor != null) {
            parameters.setParameter("candle-outline-color", this.candleOutlineColor);
        }
        return parameters;
    }

    @Override
    public void setParameters(IChartParameters parameters) {
        this.style = parameters.hasParameter("style") ? MainRenderStyle.getStyleFromName(parameters.getString("style")) : MainRenderStyle.Bars;
        this.lineColor = parameters.getColor("line-color");
        this.barPositiveColor = parameters.getColor("bar-positive-color");
        this.barNegativeColor = parameters.getColor("bar-negative-color");
        this.candlePositiveColor = parameters.getColor("candle-positive-color");
        this.candleNegativeColor = parameters.getColor("candle-negative-color");
        this.candleOutlineColor = parameters.getColor("candle-outline-color");
    }
}

