/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.charts.views.Messages;

public class SelectionProvider
implements ISelectionProvider {
    private ListenerList selectionListeners = new ListenerList(1);
    private ISelection selection;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection newSelection) {
        if (this.selection != newSelection) {
            this.selection = newSelection;
            this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, newSelection));
        }
    }

    protected void fireSelectionChangedEvent(SelectionChangedEvent event) {
        Object[] l = this.selectionListeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((ISelectionChangedListener)l[i]).selectionChanged(event);
            }
            catch (Throwable e) {
                Status status = new Status(4, "org.eclipsetrader.ui", Messages.SelectionProvider_ExceptionMessage, e);
                UIActivator.log((IStatus)status);
            }
            ++i;
        }
    }
}

