/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.editors;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipsetrader.ui.internal.editors.JavaScriptLineStyler;

public abstract class BaseJavaScriptEditor
extends ViewPart
implements ISaveablePart {
    private StyledText text;
    private Label cursorLocation;
    private boolean dirty;
    IThemeManager themeManager;
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (!BaseJavaScriptEditor.this.dirty) {
                BaseJavaScriptEditor.this.dirty = true;
                BaseJavaScriptEditor.this.firePropertyChange(257);
            }
        }
    };
    private final IPropertyChangeListener preferencesChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ITheme newTheme;
            if ("TEXT_EDITOR_FONT".equals(event.getProperty())) {
                BaseJavaScriptEditor.this.text.setFont((Font)event.getNewValue());
            } else if ("CHANGE_CURRENT_THEME".equals(event.getProperty()) && (newTheme = (ITheme)event.getOldValue()) != null) {
                BaseJavaScriptEditor.this.text.setFont(newTheme.getFontRegistry().get("TEXT_EDITOR_FONT"));
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.themeManager = PlatformUI.getWorkbench().getThemeManager();
        Composite contents = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        contents.setLayout((Layout)gridLayout);
        this.text = new StyledText(contents, 66112);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setMargins(5, 5, 5, 5);
        this.text.addLineStyleListener((LineStyleListener)new JavaScriptLineStyler());
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                BaseJavaScriptEditor.this.updateCursorLocation();
            }
        });
        this.createStatusBar(contents);
        ITheme theme = this.themeManager.getCurrentTheme();
        this.text.setFont(theme.getFontRegistry().get("TEXT_EDITOR_FONT"));
        this.themeManager.addPropertyChangeListener(this.preferencesChangeListener);
        this.text.addModifyListener(this.modifyListener);
        this.updateCursorLocation();
    }

    private void createStatusBar(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(5, false));
        contents.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GC gc = new GC((Drawable)parent);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)12);
        Label label = new Label(contents, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(contents, 514);
        label.setLayoutData((Object)new GridData(-1, heightHint));
        this.cursorLocation = new Label(contents, 0);
        this.cursorLocation.setLayoutData((Object)new GridData(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)60), -1));
        this.cursorLocation.setAlignment(0x1000000);
        label = new Label(contents, 514);
        label.setLayoutData((Object)new GridData(-1, heightHint));
        label = new Label(contents, 0);
        label.setLayoutData((Object)new GridData(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)16), -1));
    }

    public void setText(String text) {
        this.text.removeModifyListener(this.modifyListener);
        try {
            this.text.setText(text);
            this.updateCursorLocation();
        }
        finally {
            this.text.addModifyListener(this.modifyListener);
        }
    }

    public String getText() {
        return this.text.getText();
    }

    private void updateCursorLocation() {
        int caret = this.text.getCaretOffset();
        int line = this.text.getLineAtOffset(caret);
        int column = caret - this.text.getOffsetAtLine(line);
        this.cursorLocation.setText(String.format("%d : %d", column + 1, line + 1));
    }

    public void setFocus() {
        this.text.getParent().setFocus();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isSaveOnCloseNeeded() {
        return this.dirty;
    }

    public void dispose() {
        this.themeManager.removePropertyChangeListener(this.preferencesChangeListener);
        super.dispose();
    }
}

