/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipsetrader.core.internal.markets.Market;
import org.eclipsetrader.ui.PriorityPreferenceNode;
import org.eclipsetrader.ui.internal.handlers.Messages;
import org.eclipsetrader.ui.internal.markets.GeneralPage;

public class MarketPropertiesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty()) {
            Object target = selection.getFirstElement();
            if (target instanceof IAdaptable) {
                target = ((IAdaptable)target).getAdapter(Market.class);
            }
            if (target instanceof Market) {
                this.openPropertiesDialog(site.getShell(), this.getWrappedElement(target));
            }
        }
        return null;
    }

    protected void openPropertiesDialog(Shell shell, final IAdaptable adaptableElement) {
        if (adaptableElement.getAdapter(Market.class) != null) {
            PropertyPageManager pageManager = new PropertyPageManager();
            pageManager.addToRoot((IPreferenceNode)new PriorityPreferenceNode("org.eclipsetrader.ui.propertypages.markets.general", (IPreferencePage)new GeneralPage(), -1));
            PropertyPageContributorManager.getManager().contribute(pageManager, (Object)adaptableElement);
            for (Object nodeObj : pageManager.getElements(0)) {
                IPreferenceNode node = (IPreferenceNode)nodeObj;
                if (!(node.getPage() instanceof PropertyPage)) continue;
                ((PropertyPage)node.getPage()).setElement(adaptableElement);
            }
            FilteredPreferenceDialog dlg = new FilteredPreferenceDialog(shell, (PreferenceManager)pageManager){

                protected void configureShell(Shell newShell) {
                    super.configureShell(newShell);
                    Market market = (Market)adaptableElement.getAdapter(Market.class);
                    newShell.setText(String.valueOf(Messages.MarketPropertiesHandler_PropertiesFor) + market.getName());
                }
            };
            dlg.open();
        }
    }

    protected IAdaptable getWrappedElement(final Object element) {
        if (element instanceof IAdaptable) {
            return (IAdaptable)element;
        }
        return new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter.isAssignableFrom(element.getClass())) {
                    return element;
                }
                return null;
            }
        };
    }
}

