/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipsetrader.core.instruments.CurrencyExchange;
import org.eclipsetrader.core.instruments.Security;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.ui.PriorityPreferenceNode;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.handlers.Messages;
import org.eclipsetrader.ui.internal.securities.properties.CurrencyGeneralProperties;
import org.eclipsetrader.ui.internal.securities.properties.GeneralProperties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SecurityPropertiesHandler
extends AbstractHandler {
    private GeneralProperties generalProperties;
    private CurrencyGeneralProperties currencyGeneralProperties;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty()) {
            Object target = selection.getFirstElement();
            if (target instanceof IAdaptable) {
                target = ((IAdaptable)target).getAdapter(Security.class);
            }
            if (target instanceof Security) {
                this.openPropertiesDialog(site.getShell(), this.getWrappedElement(target));
            }
        }
        return null;
    }

    protected void openPropertiesDialog(Shell shell, final IAdaptable adaptableElement) {
        BundleContext context;
        ServiceReference serviceReference;
        PropertyPageManager pageManager = new PropertyPageManager();
        if (adaptableElement.getAdapter(Security.class) != null) {
            if (adaptableElement.getAdapter(CurrencyExchange.class) != null) {
                this.currencyGeneralProperties = new CurrencyGeneralProperties();
                pageManager.addToRoot((IPreferenceNode)new PriorityPreferenceNode("org.eclipsetrader.ui.propertypages.general", (IPreferencePage)this.currencyGeneralProperties, -1));
            } else {
                this.generalProperties = new GeneralProperties();
                pageManager.addToRoot((IPreferenceNode)new PriorityPreferenceNode("org.eclipsetrader.ui.propertypages.general", (IPreferencePage)this.generalProperties, -1));
            }
        }
        PropertyPageContributorManager.getManager().contribute(pageManager, (Object)adaptableElement);
        for (Object nodeObj : pageManager.getElements(0)) {
            IPreferenceNode node = (IPreferenceNode)nodeObj;
            if (!(node.getPage() instanceof PropertyPage)) continue;
            ((PropertyPage)node.getPage()).setElement(adaptableElement);
        }
        FilteredPreferenceDialog dlg = new FilteredPreferenceDialog(shell, (PreferenceManager)pageManager){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                Security security = (Security)adaptableElement.getAdapter(Security.class);
                newShell.setText(String.valueOf(Messages.SecurityPropertiesHandler_PropertiesFor) + security.getName());
            }
        };
        dlg.setHelpAvailable(false);
        if (dlg.open() == 0 && (serviceReference = (context = UIActivator.getDefault().getBundle().getBundleContext()).getServiceReference(IRepositoryService.class.getName())) != null) {
            final IRepositoryService service = (IRepositoryService)context.getService(serviceReference);
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    service.runInService(new IRepositoryRunnable(){

                        public IStatus run(IProgressMonitor monitor) throws Exception {
                            IRepository repository;
                            IStoreObject storeObject = (IStoreObject)adaptableElement.getAdapter(IStoreObject.class);
                            IRepository iRepository = repository = SecurityPropertiesHandler.this.generalProperties != null ? SecurityPropertiesHandler.this.generalProperties.getRepository() : SecurityPropertiesHandler.this.currencyGeneralProperties.getRepository();
                            if (repository != storeObject.getStore().getRepository()) {
                                service.moveAdaptable(new IAdaptable[]{adaptableElement}, repository);
                            } else {
                                service.saveAdaptable(new IAdaptable[]{adaptableElement});
                            }
                            return Status.OK_STATUS;
                        }
                    }, null);
                }
            });
        }
    }

    protected IAdaptable getWrappedElement(final Object element) {
        if (element instanceof IAdaptable) {
            return (IAdaptable)element;
        }
        return new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter.isAssignableFrom(element.getClass())) {
                    return element;
                }
                return null;
            }
        };
    }
}

