/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.ui.internal.UIActivator;

public class WatchListOpenHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty()) {
            for (Object target : selection) {
                if (target instanceof IAdaptable) {
                    target = ((IAdaptable)target).getAdapter(IWatchList.class);
                }
                if (!(target instanceof IWatchList)) continue;
                IWatchList watchList = (IWatchList)target;
                try {
                    IStoreObject storeObject = (IStoreObject)watchList.getAdapter(IStoreObject.class);
                    IDialogSettings dialogSettings = UIActivator.getDefault().getDialogSettingsForView(storeObject.getStore().toURI());
                    site.getPage().showView("org.eclipsetrader.ui.views.watchlist", dialogSettings.getName(), 1);
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error opening watchlist view", (Throwable)e);
                    UIActivator.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        return null;
    }
}

