/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.feed.IBackfillConnector;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.feed.IFeedService;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.markets.Market;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.markets.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConnectorsPage
extends PropertyPage {
    ComboViewer liveFeed;
    ComboViewer backfillFeed;
    ComboViewer intradayBackfillFeed;

    public ConnectorsPage() {
        this.setTitle(Messages.ConnectorsPage_Connectors);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.ConnectorsPage_LineFeed);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.liveFeed = new ComboViewer(content, 8);
        this.liveFeed.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.liveFeed.getCombo().setVisibleItemCount(15);
        this.liveFeed.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IFeedConnector)) {
                    IFeedConnector defaultConnector = CoreActivator.getDefault() != null ? CoreActivator.getDefault().getDefaultConnector() : null;
                    return NLS.bind((String)Messages.ConnectorsPage_Default, (Object[])new Object[]{defaultConnector != null ? defaultConnector.getName() : Messages.ConnectorsPage_None});
                }
                return ((IFeedConnector)element).getName();
            }
        });
        this.liveFeed.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof IFeedConnector) {
                    return 1;
                }
                return 0;
            }
        });
        this.liveFeed.setContentProvider((IContentProvider)new ArrayContentProvider());
        label = new Label(content, 0);
        label.setText(Messages.ConnectorsPage_HistoryBackfill);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.backfillFeed = new ComboViewer(content, 8);
        this.backfillFeed.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.backfillFeed.getCombo().setVisibleItemCount(15);
        this.backfillFeed.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IBackfillConnector)) {
                    return Messages.ConnectorsPage_None;
                }
                return ((IBackfillConnector)element).getName();
            }
        });
        this.backfillFeed.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof IBackfillConnector) {
                    return 1;
                }
                return 0;
            }
        });
        this.backfillFeed.setContentProvider((IContentProvider)new ArrayContentProvider());
        label = new Label(content, 0);
        label.setText(Messages.ConnectorsPage_IntradayBackfill);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.intradayBackfillFeed = new ComboViewer(content, 8);
        this.intradayBackfillFeed.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.intradayBackfillFeed.getCombo().setVisibleItemCount(15);
        this.intradayBackfillFeed.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IBackfillConnector)) {
                    Object o = ((IStructuredSelection)ConnectorsPage.this.backfillFeed.getSelection()).getFirstElement();
                    return NLS.bind((String)Messages.ConnectorsPage_Default, (Object[])new Object[]{o instanceof IBackfillConnector ? ((IBackfillConnector)o).getName() : Messages.ConnectorsPage_None});
                }
                return ((IBackfillConnector)element).getName();
            }
        });
        this.intradayBackfillFeed.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof IBackfillConnector) {
                    return 1;
                }
                return 0;
            }
        });
        this.intradayBackfillFeed.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<Object> feedConnectors = new ArrayList<Object>();
        feedConnectors.add(new Object());
        if (this.getFeedService() != null) {
            feedConnectors.addAll(Arrays.asList(this.getFeedService().getConnectors()));
        }
        this.liveFeed.setInput((Object)feedConnectors.toArray());
        this.liveFeed.setSelection((ISelection)new StructuredSelection(feedConnectors.get(0)));
        final Object defaultBackfillElement = new Object();
        ArrayList<Object> backfillConnectors = new ArrayList<Object>();
        backfillConnectors.add(defaultBackfillElement);
        if (this.getFeedService() != null) {
            backfillConnectors.addAll(Arrays.asList(this.getFeedService().getBackfillConnectors()));
        }
        this.backfillFeed.setInput((Object)backfillConnectors.toArray());
        this.backfillFeed.setSelection((ISelection)new StructuredSelection(defaultBackfillElement));
        this.backfillFeed.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConnectorsPage.this.intradayBackfillFeed.update(defaultBackfillElement, null);
            }
        });
        this.intradayBackfillFeed.setInput((Object)backfillConnectors.toArray());
        this.intradayBackfillFeed.setSelection((ISelection)new StructuredSelection(defaultBackfillElement));
        Market market = (Market)this.getElement().getAdapter(Market.class);
        if (market != null) {
            IBackfillConnector backfillConnector;
            IFeedConnector liveConnector = market.getLiveFeedConnector();
            if (liveConnector != null) {
                if (!feedConnectors.contains(liveConnector)) {
                    feedConnectors.add(liveConnector);
                    this.liveFeed.setInput((Object)feedConnectors.toArray());
                }
                this.liveFeed.setSelection((ISelection)new StructuredSelection((Object)liveConnector));
            }
            if ((backfillConnector = market.getBackfillConnector()) != null) {
                if (!backfillConnectors.contains(backfillConnector)) {
                    backfillConnectors.add(backfillConnector);
                    this.backfillFeed.setInput((Object)backfillConnectors.toArray());
                    this.intradayBackfillFeed.setInput((Object)backfillConnectors.toArray());
                }
                this.backfillFeed.setSelection((ISelection)new StructuredSelection((Object)backfillConnector));
            }
            if ((backfillConnector = market.getIntradayBackfillConnector()) != null) {
                if (!backfillConnectors.contains(backfillConnector)) {
                    backfillConnectors.add(backfillConnector);
                    this.backfillFeed.setInput((Object)backfillConnectors.toArray());
                    this.intradayBackfillFeed.setInput((Object)backfillConnectors.toArray());
                }
                this.intradayBackfillFeed.setSelection((ISelection)new StructuredSelection((Object)backfillConnector));
            } else {
                this.intradayBackfillFeed.setSelection((ISelection)new StructuredSelection(defaultBackfillElement));
            }
        }
        return content;
    }

    public boolean isValid() {
        return true;
    }

    public boolean performOk() {
        Market market;
        if (this.isControlCreated() && this.getElement() != null && (market = (Market)this.getElement().getAdapter(Market.class)) != null) {
            Object s = ((IStructuredSelection)this.liveFeed.getSelection()).getFirstElement();
            market.setLiveFeedConnector(s instanceof IFeedConnector ? (IFeedConnector)s : null);
            s = ((IStructuredSelection)this.backfillFeed.getSelection()).getFirstElement();
            market.setBackfillConnector(s instanceof IBackfillConnector ? (IBackfillConnector)s : null);
            s = ((IStructuredSelection)this.intradayBackfillFeed.getSelection()).getFirstElement();
            market.setIntradayBackfillConnector(s instanceof IBackfillConnector ? (IBackfillConnector)s : null);
        }
        return super.performOk();
    }

    protected IFeedService getFeedService() {
        if (UIActivator.getDefault() == null) {
            return null;
        }
        try {
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IFeedService.class.getName());
            IFeedService service = (IFeedService)context.getService(serviceReference);
            context.ungetService(serviceReference);
            return service;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, Messages.ConnectorsPage_ErrorReadingFeedService, (Throwable)e);
            UIActivator.log((IStatus)status);
            return null;
        }
    }

    protected ITradingService getTradingService() {
        if (UIActivator.getDefault() == null) {
            return null;
        }
        try {
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(ITradingService.class.getName());
            ITradingService service = (ITradingService)context.getService(serviceReference);
            context.ungetService(serviceReference);
            return service;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, Messages.ConnectorsPage_ErrorReadingTradingService, (Throwable)e);
            UIActivator.log((IStatus)status);
            return null;
        }
    }
}

