/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.util.Calendar;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipsetrader.ui.Util;
import org.eclipsetrader.ui.internal.markets.MarketHolidayElement;
import org.eclipsetrader.ui.internal.markets.Messages;

public class HolidayDialog
extends Dialog {
    CDateTime date;
    Text description;
    Button closed;
    Button open;
    Label openTimeLabel;
    CDateTime openTime;
    Label closeTimeLabel;
    CDateTime closeTime;
    MarketHolidayElement element;
    private SelectionAdapter buttonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            HolidayDialog.this.updateButtonsEnablement();
        }
    };
    private ModifyListener validationModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            HolidayDialog.this.getButton(0).setEnabled(HolidayDialog.this.isValid());
        }
    };
    private SelectionAdapter validationSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            HolidayDialog.this.getButton(0).setEnabled(HolidayDialog.this.isValid());
        }
    };

    public HolidayDialog(Shell parentShell, MarketHolidayElement day) {
        super(parentShell);
        this.element = day;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.HolidayDialog_EditMarketHoliday);
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        Label label = new Label(content, 0);
        label.setText(Messages.HolidayDialog_Date);
        this.date = new CDateTime(content, 34603011);
        this.date.setPattern(Util.getDateFormatPattern());
        label = new Label(content, 0);
        label.setText(Messages.HolidayDialog_Description);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(50), -1));
        this.description = new Text(content, 2048);
        this.description.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.description.getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        label = new Label(content, 0);
        this.closed = new Button(content, 16);
        this.closed.setText(Messages.HolidayDialog_MarketClosed);
        label = new Label(content, 0);
        this.open = new Button(content, 16);
        this.open.setText(Messages.HolidayDialog_MarketPartiallyOpen);
        this.openTimeLabel = new Label(content, 0);
        this.openTimeLabel.setText(Messages.HolidayDialog_OpenTime);
        this.openTime = new CDateTime(content, 0x6000001);
        this.openTime.setPattern("HH:mm");
        this.openTime.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(50), -1));
        this.openTime.setNullText("");
        this.closeTimeLabel = new Label(content, 0);
        this.closeTimeLabel.setText(Messages.HolidayDialog_CloseTime);
        this.closeTime = new CDateTime(content, 0x6000001);
        this.closeTime.setPattern("HH:mm");
        this.closeTime.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(50), -1));
        this.closeTime.setNullText("");
        if (this.element != null) {
            this.date.setSelection(this.element.getDate());
            this.description.setText(this.element.getDescription() != null ? this.element.getDescription() : "");
            this.closed.setSelection(this.element.getOpenTime() == null || this.element.getCloseTime() == null);
            this.open.setSelection(this.element.getOpenTime() != null && this.element.getCloseTime() != null);
            this.openTime.setSelection(this.element.getOpenTime());
            this.closeTime.setSelection(this.element.getCloseTime());
        } else {
            this.date.setSelection(Calendar.getInstance().getTime());
            this.description.setText("");
            this.closed.setSelection(true);
            this.open.setSelection(false);
            this.openTime.setSelection(null);
            this.closeTime.setSelection(null);
        }
        this.date.addSelectionListener((SelectionListener)this.validationSelectionListener);
        this.description.addModifyListener(this.validationModifyListener);
        this.closed.addSelectionListener((SelectionListener)this.buttonSelectionListener);
        this.open.addSelectionListener((SelectionListener)this.buttonSelectionListener);
        this.openTime.addSelectionListener((SelectionListener)this.validationSelectionListener);
        this.closeTime.addSelectionListener((SelectionListener)this.validationSelectionListener);
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateButtonsEnablement();
        return control;
    }

    protected void updateButtonsEnablement() {
        this.openTimeLabel.setEnabled(this.open.getSelection());
        this.openTime.setEnabled(this.open.getSelection());
        this.closeTimeLabel.setEnabled(this.open.getSelection());
        this.closeTime.setEnabled(this.open.getSelection());
        this.getButton(0).setEnabled(this.isValid());
    }

    protected boolean isValid() {
        if (this.date.getSelection() == null) {
            return false;
        }
        if (this.description.getText().equals("")) {
            return false;
        }
        if (this.open.getSelection()) {
            if (this.openTime.getSelection() == null) {
                return false;
            }
            if (this.closeTime.getSelection() == null) {
                return false;
            }
        }
        return true;
    }

    protected void okPressed() {
        this.commitChanges();
        super.okPressed();
    }

    protected void commitChanges() {
        if (this.element == null) {
            this.element = new MarketHolidayElement();
        }
        this.element.setDate(this.date.getSelection());
        this.element.setDescription(!this.description.getText().equals("") ? this.description.getText() : null);
        this.element.setOpenTime(this.open.getSelection() ? this.openTime.getSelection() : null);
        this.element.setCloseTime(this.open.getSelection() ? this.closeTime.getSelection() : null);
    }

    public MarketHolidayElement getElement() {
        return this.element;
    }
}

