/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.internal.markets.Market;
import org.eclipsetrader.core.internal.markets.MarketHoliday;
import org.eclipsetrader.ui.internal.markets.HolidayDialog;
import org.eclipsetrader.ui.internal.markets.MarketHolidayElement;
import org.eclipsetrader.ui.internal.markets.MarketHolidayLabelProvider;
import org.eclipsetrader.ui.internal.markets.Messages;

public class HolidaysPage
extends PropertyPage {
    TableViewer viewer;
    Button add;
    Button edit;
    Button remove;
    List<MarketHolidayElement> input;

    public HolidaysPage() {
        this.setTitle(Messages.HolidaysPage_Holidays);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Market market;
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)content.getLayout()).marginWidth = 0;
        ((GridLayout)content.getLayout()).marginHeight = 0;
        this.createViewer(content);
        this.createButtons(content);
        this.input = new ArrayList<MarketHolidayElement>();
        if (this.getElement() != null && (market = (Market)this.getElement().getAdapter(Market.class)) != null) {
            MarketHoliday[] marketHolidayArray = market.getHolidays();
            int n = marketHolidayArray.length;
            int n2 = 0;
            while (n2 < n) {
                MarketHoliday day = marketHolidayArray[n2];
                this.input.add(new MarketHolidayElement(day));
                ++n2;
            }
        }
        this.viewer.setInput(this.input);
        this.updateButtonsEnablement();
        return content;
    }

    protected void createViewer(Composite parent) {
        Composite content = new Composite(parent, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        content.setLayout((Layout)tableLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TableViewer(content, 68354);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(false);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.viewer.getControl().getLayoutData()).heightHint = this.viewer.getTable().getItemHeight() * 8 + this.viewer.getTable().getBorderWidth() * 2;
        TableColumn tableColumn = new TableColumn(this.viewer.getTable(), 131072);
        tableColumn.setText(Messages.HolidaysPage_Date);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnPixelData(this.convertHorizontalDLUsToPixels(60)));
        tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.HolidaysPage_Description);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(100));
        this.viewer.setLabelProvider((IBaseLabelProvider)new MarketHolidayLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((MarketHolidayElement)e1).getDate().compareTo(((MarketHolidayElement)e2).getDate());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HolidaysPage.this.updateButtonsEnablement();
            }
        });
    }

    protected void createButtons(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        ((GridLayout)content.getLayout()).marginWidth = 0;
        ((GridLayout)content.getLayout()).marginHeight = 0;
        content.setLayoutData((Object)new GridData(4, 128, false, false));
        this.add = new Button(content, 8);
        this.add.setText(Messages.HolidaysPage_Add);
        this.add.setLayoutData((Object)new GridData(4, 128, true, false));
        ((GridData)this.add.getLayoutData()).widthHint = this.convertHorizontalDLUsToPixels(61);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HolidayDialog dlg = new HolidayDialog(HolidaysPage.this.add.getShell(), null);
                if (dlg.open() == 0) {
                    HolidaysPage.this.input.add(dlg.getElement());
                    HolidaysPage.this.viewer.refresh();
                }
            }
        });
        this.edit = new Button(content, 8);
        this.edit.setText(Messages.HolidaysPage_Edit);
        this.edit.setLayoutData((Object)new GridData(4, 128, true, false));
        ((GridData)this.edit.getLayoutData()).widthHint = this.convertHorizontalDLUsToPixels(61);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)HolidaysPage.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    MarketHolidayElement element = (MarketHolidayElement)selection.getFirstElement();
                    HolidayDialog dlg = new HolidayDialog(HolidaysPage.this.edit.getShell(), element);
                    if (dlg.open() == 0) {
                        HolidaysPage.this.viewer.refresh();
                    }
                }
            }
        });
        this.remove = new Button(content, 8);
        this.remove.setText(Messages.HolidaysPage_Remove);
        this.remove.setLayoutData((Object)new GridData(4, 128, true, false));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)HolidaysPage.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    HolidaysPage.this.input.removeAll(selection.toList());
                    HolidaysPage.this.viewer.refresh();
                }
            }
        });
    }

    public boolean performOk() {
        Market market;
        if (this.isControlCreated() && this.getElement() != null && (market = (Market)this.getElement().getAdapter(Market.class)) != null) {
            MarketHoliday[] holidays = new MarketHoliday[this.input.size()];
            int i = 0;
            while (i < this.input.size()) {
                holidays[i] = this.input.get(i).getMarketHoliday();
                ++i;
            }
            market.setHolidays(holidays);
        }
        return super.performOk();
    }

    protected void updateButtonsEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.edit.setEnabled(selection.size() == 1);
        this.remove.setEnabled(!selection.isEmpty());
    }
}

