/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipsetrader.core.internal.markets.MarketTime;
import org.eclipsetrader.core.internal.markets.MarketTimeExclude;

public class MarketTimeElement
implements Comparable<MarketTimeElement> {
    private Date openTime;
    private Date closeTime;
    private String description;
    private List<MarketTimeExcludeElement> exclude = new ArrayList<MarketTimeExcludeElement>();

    public MarketTimeElement(Date openTime, Date closeTime) {
        this.openTime = openTime;
        this.closeTime = closeTime;
    }

    public MarketTimeElement(MarketTime marketTime) {
        this.openTime = marketTime.getOpenTime();
        this.closeTime = marketTime.getCloseTime();
        this.description = marketTime.getDescription();
        MarketTimeExclude[] marketTimeExcludeArray = marketTime.getExclude();
        int n = marketTimeExcludeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarketTimeExclude exclude = marketTimeExcludeArray[n2];
            this.exclude.add(new MarketTimeExcludeElement(exclude));
            ++n2;
        }
    }

    public Date getOpenTime() {
        return this.openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    public Date getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<MarketTimeExcludeElement> getExclude() {
        return this.exclude;
    }

    public MarketTime getMarketTime() {
        MarketTime marketTime = new MarketTime(this.openTime, this.closeTime, this.description);
        MarketTimeExclude[] exclude = new MarketTimeExclude[this.exclude.size()];
        int i = 0;
        while (i < exclude.length) {
            exclude[i] = this.exclude.get(i).getMarketTimeExclude();
            ++i;
        }
        marketTime.setExclude(exclude);
        return marketTime;
    }

    @Override
    public int compareTo(MarketTimeElement o) {
        return this.openTime.compareTo(o.openTime);
    }

    public static class MarketTimeExcludeElement
    implements Comparable<MarketTimeExcludeElement> {
        private Date fromDate;
        private Date toDate;

        public MarketTimeExcludeElement(Date fromDate, Date toDate) {
            this.fromDate = fromDate;
            this.toDate = toDate;
        }

        public MarketTimeExcludeElement(MarketTimeExclude exclude) {
            this.fromDate = exclude.getFromDate();
            this.toDate = exclude.getToDate() != null ? exclude.getToDate() : exclude.getFromDate();
        }

        public Date getFromDate() {
            return this.fromDate;
        }

        public void setFromDate(Date fromDate) {
            this.fromDate = fromDate;
        }

        public Date getToDate() {
            return this.toDate;
        }

        public void setToDate(Date toDate) {
            this.toDate = toDate;
        }

        public MarketTimeExclude getMarketTimeExclude() {
            if (this.fromDate.equals(this.toDate)) {
                return new MarketTimeExclude(this.fromDate);
            }
            return new MarketTimeExclude(this.fromDate, this.toDate);
        }

        @Override
        public int compareTo(MarketTimeExcludeElement o) {
            return this.fromDate.compareTo(o.fromDate);
        }
    }
}

