/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.TimeZone;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipsetrader.core.internal.markets.MarketTime;
import org.eclipsetrader.ui.internal.markets.MarketTimeElement;
import org.eclipsetrader.ui.internal.markets.Messages;
import org.eclipsetrader.ui.internal.markets.TimeScheduleEditor;

public class ScheduleWizardPage
extends WizardPage {
    TimeScheduleEditor schedule;
    Button sun;
    Button mon;
    Button tue;
    Button wed;
    Button thu;
    Button fri;
    Button sat;
    ComboViewer timeZone;

    public ScheduleWizardPage() {
        super("schedule", Messages.ScheduleWizardPage_Schedule, null);
        this.setDescription(Messages.ScheduleWizardPage_SetMarketTimeSchedule);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)content);
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(content, 0);
        label.setText(Messages.ScheduleWizardPage_Schedule);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.schedule = new TimeScheduleEditor(content);
        ((GridData)this.schedule.getControl().getLayoutData()).horizontalSpan = 2;
        ((GridData)this.schedule.getControl().getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.schedule.getControl().getLayoutData()).verticalAlignment = 4;
        this.schedule.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ScheduleWizardPage.this.setPageComplete(ScheduleWizardPage.this.isPageComplete());
            }
        });
        this.schedule.getInput().add(new MarketTimeElement(this.getTime(9, 0), this.getTime(16, 0)));
        this.schedule.getViewer().refresh();
        label = new Label(content, 0);
        label.setText(Messages.ScheduleWizardPage_WeekDays);
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        ((GridData)label.getLayoutData()).widthHint = this.convertHorizontalDLUsToPixels(80);
        ((GridData)label.getLayoutData()).verticalIndent = this.convertHorizontalDLUsToPixels(3);
        Composite group = new Composite(content, 0);
        GridLayout gridLayout = new GridLayout(5, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1, 128, false, false));
        this.mon = new Button(group, 32);
        this.mon.setText(Messages.ScheduleWizardPage_Mon);
        this.mon.setSelection(true);
        this.tue = new Button(group, 32);
        this.tue.setText(Messages.ScheduleWizardPage_Tue);
        this.tue.setSelection(true);
        this.wed = new Button(group, 32);
        this.wed.setText(Messages.ScheduleWizardPage_Wed);
        this.wed.setSelection(true);
        this.thu = new Button(group, 32);
        this.thu.setText(Messages.ScheduleWizardPage_Thu);
        this.thu.setSelection(true);
        this.fri = new Button(group, 32);
        this.fri.setText(Messages.ScheduleWizardPage_Fri);
        this.fri.setSelection(true);
        this.sun = new Button(group, 32);
        this.sun.setText(Messages.ScheduleWizardPage_Sun);
        this.sat = new Button(group, 32);
        this.sat.setText(Messages.ScheduleWizardPage_Sat);
        label = new Label(content, 0);
        label.setText(Messages.ScheduleWizardPage_TimeZone);
        this.timeZone = new ComboViewer(content, 8);
        this.timeZone.getCombo().setVisibleItemCount(15);
        this.timeZone.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.timeZone.setSorter(new ViewerSorter());
        this.timeZone.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.timeZone.setInput((Object)TimeZone.getAvailableIDs());
        this.timeZone.setSelection((ISelection)new StructuredSelection((Object)TimeZone.getDefault().getID()));
        this.schedule.getControl().setFocus();
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        if (this.schedule.getInput().size() == 0) {
            return false;
        }
        return this.sun.getSelection() || this.mon.getSelection() || this.tue.getSelection() || this.wed.getSelection() || this.thu.getSelection() || this.fri.getSelection() || this.sat.getSelection();
    }

    public MarketTime[] getSchedule() {
        return this.schedule.getSchedule();
    }

    public Integer[] getWeekDays() {
        HashSet<Integer> weekdays = new HashSet<Integer>();
        if (this.sun.getSelection()) {
            weekdays.add(1);
        }
        if (this.mon.getSelection()) {
            weekdays.add(2);
        }
        if (this.tue.getSelection()) {
            weekdays.add(3);
        }
        if (this.wed.getSelection()) {
            weekdays.add(4);
        }
        if (this.thu.getSelection()) {
            weekdays.add(5);
        }
        if (this.fri.getSelection()) {
            weekdays.add(6);
        }
        if (this.sat.getSelection()) {
            weekdays.add(7);
        }
        return weekdays.toArray(new Integer[weekdays.size()]);
    }

    public TimeZone getTimeZone() {
        if (!this.timeZone.getSelection().isEmpty()) {
            String id = ((StructuredSelection)this.timeZone.getSelection()).getFirstElement().toString();
            return TimeZone.getTimeZone(id);
        }
        return null;
    }

    private Date getTime(int hour, int minute) {
        Calendar date = Calendar.getInstance();
        date.set(11, hour);
        date.set(12, minute);
        date.set(13, 0);
        date.set(14, 0);
        return date.getTime();
    }
}

