/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.navigator;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.views.IView;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;
import org.eclipsetrader.core.views.IViewVisitor;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.ui.SelectionProvider;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.navigator.InstrumentTypeGroup;
import org.eclipsetrader.ui.internal.navigator.MarketGroup;
import org.eclipsetrader.ui.internal.navigator.NavigatorContentProvider;
import org.eclipsetrader.ui.internal.navigator.NavigatorLabelProvider;
import org.eclipsetrader.ui.internal.navigator.NavigatorView;
import org.eclipsetrader.ui.internal.navigator.NavigatorViewItem;
import org.eclipsetrader.ui.internal.navigator.SecuritiesContentProvider;
import org.eclipsetrader.ui.internal.navigator.WatchListsContentProvider;
import org.eclipsetrader.ui.internal.repositories.Messages;
import org.eclipsetrader.ui.navigator.INavigatorContentGroup;
import org.eclipsetrader.ui.navigator.SecurityObjectTransfer;

public class Navigator
extends ViewPart {
    private TreeViewer viewer;
    private IMemento memento;
    private Action collapseAllAction;
    private Action expandAllAction;
    private Action deleteAction;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
        ImageRegistry imageRegistry = UIActivator.getDefault().getImageRegistry();
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
        this.collapseAllAction = new Action(Messages.Navigator_CollapseAll, imageRegistry.getDescriptor("collapseall")){

            public void run() {
                Navigator.this.viewer.collapseAll();
            }
        };
        this.expandAllAction = new Action(Messages.Navigator_ExpandAll, imageRegistry.getDescriptor("expandall")){

            public void run() {
                Navigator.this.viewer.expandAll();
            }
        };
        this.deleteAction = new Action(Messages.Navigator_Delete){

            public void run() {
                final IAdaptable[] objects = Navigator.this.getSelectedObject(Navigator.this.viewer.getSelection());
                if (objects.length != 0) {
                    if (!MessageDialog.openConfirm((Shell)Navigator.this.getViewSite().getShell(), (String)Navigator.this.getPartName(), (String)Messages.RepositoryExplorer_DeleteConfirmMessage)) {
                        return;
                    }
                    final IRepositoryService service = UIActivator.getDefault().getRepositoryService();
                    service.runInService(new IRepositoryRunnable(){

                        public IStatus run(IProgressMonitor monitor) throws Exception {
                            service.deleteAdaptable(objects);
                            return Status.OK_STATUS;
                        }
                    }, null);
                }
            }
        };
        this.deleteAction.setImageDescriptor(imageRegistry.getDescriptor("delete_edit"));
        this.deleteAction.setDisabledImageDescriptor(imageRegistry.getDescriptor("delete_edit_disabled"));
        this.deleteAction.setId(ActionFactory.DELETE.getId());
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.deleteAction.setEnabled(false);
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.expandAllAction);
        toolBarManager.add((IAction)this.collapseAllAction);
        site.getActionBars().setGlobalActionHandler(this.deleteAction.getId(), (IAction)this.deleteAction);
        site.getActionBars().updateActionBars();
    }

    public void createPartControl(Composite parent) {
        String s;
        this.viewer = new TreeViewer(parent, 65538);
        this.viewer.setUseHashlookup(true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new NavigatorLabelProvider(), WorkbenchPlugin.getDefault().getDecoratorManager().getLabelDecorator()));
        this.viewer.setContentProvider((IContentProvider)new NavigatorContentProvider());
        this.viewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof IAdaptable) {
                    if (((IAdaptable)element).getAdapter(ISecurity.class) != null) {
                        return 1;
                    }
                    if (((IAdaptable)element).getAdapter(IWatchList.class) != null) {
                        return 2;
                    }
                    if (((IAdaptable)element).getAdapter(IRepository.class) != null) {
                        return 3;
                    }
                }
                return 0;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IAdaptable && e2 instanceof IAdaptable && ((IAdaptable)e1).getAdapter(String.class) != null && ((IAdaptable)e2).getAdapter(String.class) != null) {
                    return 0;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        DragSource dragSource = new DragSource(this.viewer.getControl(), 3);
        dragSource.setTransfer(new Transfer[]{SecurityObjectTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                event.doit = Navigator.this.getSelectedObject(Navigator.this.viewer.getSelection()).length != 0;
            }

            public void dragSetData(DragSourceEvent event) {
                if (SecurityObjectTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = Navigator.this.getSelectedObject(Navigator.this.viewer.getSelection());
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("group.new"));
                menuManager.add((IContributionItem)new GroupMarker("group.goto"));
                menuManager.add((IContributionItem)new Separator("group.open"));
                menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
                menuManager.add((IContributionItem)new Separator("group.trade"));
                menuManager.add((IContributionItem)new GroupMarker("group.tradeWith"));
                menuManager.add((IContributionItem)new Separator("group.show"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
                menuManager.add((IContributionItem)new GroupMarker("group.port"));
                menuManager.add((IContributionItem)new Separator("group.generate"));
                menuManager.add((IContributionItem)new Separator("group.search"));
                menuManager.add((IContributionItem)new Separator("group.build"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("group.properties"));
                menuManager.appendToGroup("group.show", (IAction)new Action(Messages.Navigator_ExpandAll){

                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)Navigator.this.viewer.getSelection();
                        Iterator iter = selection.iterator();
                        while (iter.hasNext()) {
                            Navigator.this.viewer.expandToLevel(iter.next(), -1);
                        }
                    }
                });
                menuManager.appendToGroup("group.reorganize", (IAction)Navigator.this.deleteAction);
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                try {
                    IHandlerService service = (IHandlerService)Navigator.this.getSite().getService(IHandlerService.class);
                    service.executeCommand("org.eclipse.ui.file.open", null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IAdaptable[] objects = Navigator.this.getSelectedObject(event.getSelection());
                Navigator.this.deleteAction.setEnabled(objects.length != 0);
                Navigator.this.getViewSite().getSelectionProvider().setSelection(event.getSelection());
            }
        });
        NavigatorView view = new NavigatorView();
        view.setContentProviders(new IStructuredContentProvider[]{new SecuritiesContentProvider(), new WatchListsContentProvider()});
        view.setGroups(new INavigatorContentGroup[]{new InstrumentTypeGroup(), new MarketGroup()});
        view.update();
        this.viewer.setInput((Object)view);
        if (this.memento != null && (s = this.memento.getString("expanded")) != null) {
            String[] sr = s.split(";");
            final HashSet<Integer> itemHash = new HashSet<Integer>();
            int i = 0;
            while (i < sr.length) {
                try {
                    itemHash.add(Integer.parseInt(sr[i]));
                }
                catch (Exception exception) {}
                ++i;
            }
            view.accept(new IViewVisitor(){

                public boolean visit(IView view) {
                    return true;
                }

                public boolean visit(IViewItem viewItem) {
                    if (itemHash.contains(viewItem.hashCode())) {
                        Navigator.this.viewer.setExpandedState((Object)viewItem, true);
                    }
                    return true;
                }
            });
        }
    }

    public void setFocus() {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void saveState(IMemento memento) {
        Object[] o = this.viewer.getExpandedElements();
        if (o != null && o.length != 0) {
            StringBuffer s = new StringBuffer();
            int i = 0;
            while (i < o.length) {
                if (i != 0) {
                    s.append(";");
                }
                s.append(o[i].hashCode());
                ++i;
            }
            memento.putString("expanded", s.toString());
        }
        super.saveState(memento);
    }

    public void dispose() {
        NavigatorView view = (NavigatorView)this.viewer.getInput();
        if (view != null) {
            view.dispose();
        }
        super.dispose();
    }

    protected IAdaptable[] getSelectedObject(ISelection selection) {
        final HashSet list = new HashSet();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof NavigatorViewItem) {
                    ((NavigatorViewItem)o).accept(new IViewItemVisitor(){

                        public boolean visit(IViewItem viewItem) {
                            IWatchList watchlist;
                            ISecurity security = (ISecurity)viewItem.getAdapter(ISecurity.class);
                            if (security != null) {
                                list.add(security);
                            }
                            if ((watchlist = (IWatchList)viewItem.getAdapter(IWatchList.class)) != null) {
                                list.add(watchlist);
                            }
                            return true;
                        }
                    });
                }
                ++n2;
            }
        }
        return list.toArray(new IAdaptable[list.size()]);
    }
}

