/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.navigator;

import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.navigator.NavigatorViewItem;

public class NavigatorLabelProvider
extends LabelProvider
implements IColorProvider {
    private Image folderIcon;
    private Image blankIcon;
    private Image marketIcon;
    private Image securityIcon;
    private Image watchListIcon;

    public NavigatorLabelProvider() {
        if (UIActivator.getDefault() != null) {
            this.folderIcon = UIActivator.getDefault().getImageRegistry().get("folder_obj");
            this.blankIcon = UIActivator.getDefault().getImageRegistry().get("blank_obj");
            this.marketIcon = UIActivator.getDefault().getImageRegistry().get("market_fldr");
            this.securityIcon = UIActivator.getDefault().getImageRegistry().get("repository_object");
            this.watchListIcon = UIActivator.getDefault().getImageRegistry().get("repository_object");
        }
    }

    public Image getImage(Object element) {
        NavigatorViewItem viewItem = (NavigatorViewItem)element;
        ILabelProvider labelProvider = (ILabelProvider)AdapterManager.getDefault().getAdapter(viewItem.getReference(), ILabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getImage(element);
        }
        if (viewItem.getReference() instanceof IMarket) {
            return this.marketIcon;
        }
        if (viewItem.getReference() instanceof ISecurity) {
            return this.securityIcon;
        }
        if (viewItem.getReference() instanceof IWatchList) {
            return this.watchListIcon;
        }
        if (viewItem.getItemCount() != 0) {
            return this.folderIcon;
        }
        return this.blankIcon;
    }

    public String getText(Object element) {
        NavigatorViewItem viewItem = (NavigatorViewItem)element;
        ILabelProvider labelProvider = (ILabelProvider)AdapterManager.getDefault().getAdapter(viewItem.getReference(), ILabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getText(element);
        }
        if (viewItem.getReference() instanceof IMarket) {
            return ((IMarket)element).getName();
        }
        if (viewItem.getReference() instanceof ISecurity) {
            return ((ISecurity)element).getName();
        }
        if (viewItem.getReference() instanceof IWatchList) {
            return ((IWatchList)element).getName();
        }
        return super.getText(element);
    }

    public Color getBackground(Object element) {
        IColorProvider colorProvider = (IColorProvider)AdapterManager.getDefault().getAdapter(((NavigatorViewItem)element).getReference(), IColorProvider.class);
        if (colorProvider != null) {
            return colorProvider.getBackground(element);
        }
        return null;
    }

    public Color getForeground(Object element) {
        IColorProvider colorProvider = (IColorProvider)AdapterManager.getDefault().getAdapter(((NavigatorViewItem)element).getReference(), IColorProvider.class);
        if (colorProvider != null) {
            return colorProvider.getForeground(element);
        }
        return null;
    }
}

