/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;

public class NavigatorViewItem
implements IViewItem {
    private Object reference;
    private NavigatorViewItem parent;
    private List<NavigatorViewItem> childs = new ArrayList<NavigatorViewItem>();

    public NavigatorViewItem() {
    }

    public NavigatorViewItem(NavigatorViewItem parent, Object reference) {
        this.parent = parent;
        this.reference = reference;
    }

    public int getItemCount() {
        return this.childs != null ? this.childs.size() : 0;
    }

    public IViewItem[] getItems() {
        return this.childs.toArray(new IViewItem[this.childs.size()]);
    }

    protected void setItems(NavigatorViewItem[] items) {
        this.childs.clear();
        NavigatorViewItem[] navigatorViewItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            NavigatorViewItem viewItem = navigatorViewItemArray[n2];
            this.childs.add(viewItem);
            viewItem.parent = this;
            ++n2;
        }
    }

    public IViewItem getParent() {
        return this.parent;
    }

    public boolean hasChild(Object reference) {
        for (NavigatorViewItem viewItem : this.childs) {
            if (!viewItem.getReference().equals(reference)) continue;
            return true;
        }
        return false;
    }

    public NavigatorViewItem getChild(Object reference) {
        for (NavigatorViewItem viewItem : this.childs) {
            if (!viewItem.getReference().equals(reference)) continue;
            return viewItem;
        }
        return null;
    }

    public NavigatorViewItem createChild(Object reference) {
        NavigatorViewItem viewItem = new NavigatorViewItem(this, reference);
        this.childs.add(viewItem);
        return viewItem;
    }

    protected void addChild(NavigatorViewItem viewItem) {
        this.childs.add(viewItem);
        viewItem.parent = this;
    }

    public void removeChild(Object reference) {
        for (NavigatorViewItem viewItem : this.childs) {
            if (!viewItem.getReference().equals(reference)) continue;
            this.childs.remove(viewItem);
            break;
        }
    }

    public Iterator<NavigatorViewItem> iterator() {
        return this.childs.iterator();
    }

    public IAdaptable[] getValues() {
        return new IAdaptable[0];
    }

    public Object getReference() {
        return this.reference;
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        if (this.reference != null && adapter.isAssignableFrom(this.reference.getClass())) {
            return this.reference;
        }
        if (this.reference instanceof IAdaptable && (obj = ((IAdaptable)this.reference).getAdapter(adapter)) != null) {
            return obj;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (this.reference instanceof IAdaptable) {
            return AdapterManager.getDefault().getAdapter(this.reference, adapter);
        }
        return null;
    }

    public void accept(IViewItemVisitor visitor) {
        if (visitor.visit((IViewItem)this)) {
            IViewItem[] iViewItemArray = this.getItems();
            int n = iViewItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewItem viewItem = iViewItemArray[n2];
                viewItem.accept(visitor);
                ++n2;
            }
        }
    }

    public int hashCode() {
        return 7 * (this.reference != null ? this.reference.hashCode() : 0) + 11 * (this.parent != null ? this.parent.hashCode() : 0);
    }

    public String toString() {
        return this.reference != null ? this.reference.toString() : super.toString();
    }
}

