/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.ats.TimeSpanDialog;
import org.eclipsetrader.ui.internal.preferences.Messages;

public class BarsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ListViewer viewer;
    private Button add;
    private Button remove;
    private List<TimeSpan> list = new ArrayList<TimeSpan>();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(UIActivator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        Label label = new Label(content, 0);
        label.setText(Messages.BarsPreferencePage_BarAggregationSizes);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.viewer = new ListViewer(content, 2050);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TimeSpan timeSpan = (TimeSpan)element;
                return NLS.bind((String)"{0} {1}", (Object[])new Object[]{String.valueOf(timeSpan.getLength()), timeSpan.getUnits()});
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TimeSpan ts1 = (TimeSpan)e1;
                TimeSpan ts2 = (TimeSpan)e2;
                if (ts1.getUnits() != ts2.getUnits()) {
                    return ts2.getUnits().ordinal() - ts1.getUnits().ordinal();
                }
                return ts1.getLength() - ts2.getLength();
            }
        });
        this.viewer.setInput(this.list);
        Composite buttons = new Composite(content, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.add = new Button(buttons, 8);
        this.add.setText(Messages.BarsPreferencePage_Add);
        this.add.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSpanDialog dlg = new TimeSpanDialog(BarsPreferencePage.this.getShell());
                if (dlg.open() == 0) {
                    BarsPreferencePage.this.list.add(dlg.getSelection());
                    BarsPreferencePage.this.viewer.refresh();
                }
            }
        });
        this.remove = new Button(buttons, 8);
        this.remove.setText(Messages.BarsPreferencePage_Remove);
        this.remove.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BarsPreferencePage.this.viewer.getSelection();
                BarsPreferencePage.this.list.removeAll(selection.toList());
                BarsPreferencePage.this.viewer.refresh();
            }
        });
        this.remove.setEnabled(false);
        this.performDefaults();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BarsPreferencePage.this.remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        return content;
    }

    protected void performDefaults() {
        IPreferenceStore preferences = this.getPreferenceStore();
        this.list.clear();
        String value = preferences.getString("CHART_BARS");
        String[] s = value.split(",");
        int i = 0;
        while (i < s.length) {
            TimeSpan timeSpan = TimeSpan.fromString((String)s[i]);
            if (timeSpan != null) {
                this.list.add(timeSpan);
            }
            ++i;
        }
        this.viewer.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore preferences = this.getPreferenceStore();
        StringBuilder sb = new StringBuilder();
        for (TimeSpan timeSpan : this.list) {
            sb.append(timeSpan).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        preferences.setDefault("CHART_BARS", sb.toString());
        return super.performOk();
    }
}

