/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.feed.ILastClose;
import org.eclipsetrader.core.feed.IPrice;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.NumberValue;

public class ChangeFactory
extends AbstractProviderFactory {
    private NumberFormat formatter = NumberFormat.getInstance();
    private NumberFormat percentageFormatter = NumberFormat.getInstance();
    private Color positiveColor = Display.getDefault().getSystemColor(5);
    private Color negativeColor = Display.getDefault().getSystemColor(3);

    public ChangeFactory() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(4);
        this.percentageFormatter.setGroupingUsed(true);
        this.percentageFormatter.setMinimumIntegerDigits(1);
        this.percentageFormatter.setMinimumFractionDigits(2);
        this.percentageFormatter.setMaximumFractionDigits(2);
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Double.class, String.class};
    }

    public class DataProvider
    implements IDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return ChangeFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            ILastClose close = (ILastClose)adaptable.getAdapter(ILastClose.class);
            IPrice price = (IPrice)adaptable.getAdapter(IPrice.class);
            if (close != null && close.getPrice() != null && price != null && price.getPrice() != null) {
                Double value = price.getPrice() - close.getPrice();
                Double percentage = (price.getPrice() - close.getPrice()) / close.getPrice() * 100.0;
                String text = String.valueOf(value > 0.0 ? "+" : "") + ChangeFactory.this.formatter.format(value) + " (" + (value > 0.0 ? "+" : "") + ChangeFactory.this.percentageFormatter.format(percentage) + "%)";
                Color color = value != 0.0 ? (value > 0.0 ? ChangeFactory.this.positiveColor : ChangeFactory.this.negativeColor) : null;
                return new NumberValue(value, text, color);
            }
            return null;
        }

        public void dispose() {
        }
    }
}

