/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.DateValue;

public class LastTradeDateTimeFactory
extends AbstractProviderFactory {
    protected DateFormat formatter = DateFormat.getDateTimeInstance(2, 2);

    public LastTradeDateTimeFactory() {
    }

    protected LastTradeDateTimeFactory(DateFormat formatter) {
        this.formatter = formatter;
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Date.class, String.class};
    }

    public class DataProvider
    implements IDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return LastTradeDateTimeFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            ITrade trade = (ITrade)adaptable.getAdapter(ITrade.class);
            if (trade != null && trade.getTime() != null) {
                Date value = trade.getTime();
                return new DateValue(value, LastTradeDateTimeFactory.this.formatter.format(value));
            }
            return null;
        }

        public void dispose() {
        }
    }
}

