/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.views.Holding;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.core.views.IEditableDataProvider;
import org.eclipsetrader.core.views.IHolding;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.NumberValue;

public class PositionFactory
extends AbstractProviderFactory {
    private NumberFormat formatter = NumberFormat.getInstance();

    public PositionFactory() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(0);
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Long.class, String.class};
    }

    public class DataProvider
    implements IDataProvider,
    IEditableDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return PositionFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            IHolding holding = (IHolding)adaptable.getAdapter(IHolding.class);
            if (holding != null && holding.getPosition() != null) {
                Long value = holding.getPosition();
                return new NumberValue(value, PositionFactory.this.formatter.format(value));
            }
            IPosition position = (IPosition)adaptable.getAdapter(IPosition.class);
            if (position != null && position.getQuantity() != null) {
                Long value = position.getQuantity();
                return new NumberValue(value, PositionFactory.this.formatter.format(value));
            }
            return new NumberValue(null, "");
        }

        public void setValue(IAdaptable adaptable, Object value) {
            Holding element = (Holding)adaptable.getAdapter(Holding.class);
            if (element != null) {
                Long l = null;
                if (value instanceof Number) {
                    l = ((Number)value).longValue();
                } else if (value != null) {
                    try {
                        if (!"".equals(value.toString())) {
                            l = PositionFactory.this.formatter.parse(value.toString()).longValue();
                        }
                    }
                    catch (ParseException e) {
                        UIActivator.log("Error parsing edited position value", e);
                    }
                }
                element.setPosition(l);
            }
        }

        public void dispose() {
        }
    }
}

