/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.views.Holding;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.core.views.IEditableDataProvider;
import org.eclipsetrader.core.views.IHolding;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.NumberValue;

public class PurchasePriceFactory
extends AbstractProviderFactory {
    private NumberFormat formatter = NumberFormat.getInstance();

    public PurchasePriceFactory() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(2);
        this.formatter.setMaximumFractionDigits(4);
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Double.class, String.class};
    }

    public class DataProvider
    implements IDataProvider,
    IEditableDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return PurchasePriceFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            IHolding element = (IHolding)adaptable.getAdapter(IHolding.class);
            if (element != null) {
                Double value;
                return new NumberValue(value, (value = element.getPurchasePrice()) != null ? PurchasePriceFactory.this.formatter.format(value) : "");
            }
            return null;
        }

        public void setValue(IAdaptable adaptable, Object value) {
            Holding element = (Holding)adaptable.getAdapter(Holding.class);
            if (element != null) {
                Double l = null;
                if (value instanceof Number) {
                    l = ((Number)value).doubleValue();
                } else if (value != null) {
                    try {
                        if (!"".equals(value.toString())) {
                            l = PurchasePriceFactory.this.formatter.parse(value.toString()).doubleValue();
                        }
                    }
                    catch (ParseException e) {
                        UIActivator.log("Error parsing edited purchase price value", e);
                    }
                }
                element.setPurchasePrice(l);
            }
        }

        public void dispose() {
        }
    }
}

