/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.repositories;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryChangeListener;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.RepositoryChangeEvent;
import org.eclipsetrader.core.views.IView;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewVisitor;
import org.eclipsetrader.ui.SelectionProvider;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.repositories.Messages;
import org.eclipsetrader.ui.internal.repositories.RepositoryContentProvider;
import org.eclipsetrader.ui.internal.repositories.RepositoryLabelProvider;
import org.eclipsetrader.ui.internal.repositories.RepositoryMoveJob;
import org.eclipsetrader.ui.internal.repositories.RepositoryTree;
import org.eclipsetrader.ui.internal.repositories.RepositoryViewItem;
import org.eclipsetrader.ui.navigator.RepositoryObjectTransfer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RepositoryExplorer
extends ViewPart {
    private static final String K_EXPANDED = "expanded";
    private TreeViewer viewer;
    private IMemento memento;
    private Action refreshAction;
    private Action collapseAllAction;
    private Action expandAllAction;
    private Action copyAction;
    private Action pasteAction;
    private Action deleteAction;
    private Job refreshJob = new Job(Messages.RepositoryExplorer_RefreshJobName){

        protected IStatus run(IProgressMonitor monitor) {
            block3: {
                monitor.beginTask(this.getName(), -1);
                final RepositoryTree tree = RepositoryExplorer.this.viewer.getInput() != null ? (RepositoryTree)RepositoryExplorer.this.viewer.getInput() : new RepositoryTree(RepositoryExplorer.this.getRepositoryService());
                tree.refresh();
                if (!RepositoryExplorer.this.viewer.getControl().isDisposed()) {
                    try {
                        RepositoryExplorer.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!RepositoryExplorer.this.viewer.getControl().isDisposed()) {
                                    if (RepositoryExplorer.this.viewer.getInput() == null) {
                                        String s;
                                        RepositoryExplorer.this.viewer.setInput((Object)tree);
                                        if (RepositoryExplorer.this.memento != null && (s = RepositoryExplorer.this.memento.getString(RepositoryExplorer.K_EXPANDED)) != null) {
                                            String[] sr = s.split(";");
                                            final HashSet<Integer> itemHash = new HashSet<Integer>();
                                            int i = 0;
                                            while (i < sr.length) {
                                                try {
                                                    itemHash.add(Integer.parseInt(sr[i]));
                                                }
                                                catch (Exception exception) {}
                                                ++i;
                                            }
                                            tree.accept(new IViewVisitor(){

                                                public boolean visit(IView view) {
                                                    return true;
                                                }

                                                public boolean visit(IViewItem viewItem) {
                                                    if (itemHash.contains(viewItem.hashCode())) {
                                                        RepositoryExplorer.this.viewer.setExpandedState((Object)viewItem, true);
                                                    }
                                                    return true;
                                                }
                                            });
                                        }
                                    } else {
                                        RepositoryExplorer.this.viewer.refresh();
                                    }
                                }
                            }
                        });
                    }
                    catch (SWTException e) {
                        if (e.code == 45) break block3;
                        throw e;
                    }
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    };
    private IRepositoryChangeListener resourceListener = new IRepositoryChangeListener(){

        public void repositoryResourceChanged(RepositoryChangeEvent event) {
            try {
                RepositoryExplorer.this.refreshJob.join();
            }
            catch (Exception exception) {}
            RepositoryExplorer.this.refreshJob.schedule();
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
        ImageRegistry imageRegistry = UIActivator.getDefault().getImageRegistry();
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
        this.refreshAction = new Action(Messages.RepositoryExplorer_Refresh, imageRegistry.getDescriptor("refresh")){

            public void run() {
                RepositoryExplorer.this.refreshJob.setUser(true);
                RepositoryExplorer.this.refreshJob.schedule();
            }
        };
        this.collapseAllAction = new Action(Messages.RepositoryExplorer_CollapseAll, imageRegistry.getDescriptor("collapseall")){

            public void run() {
                RepositoryExplorer.this.viewer.collapseAll();
            }
        };
        this.expandAllAction = new Action(Messages.RepositoryExplorer_ExpandAll, imageRegistry.getDescriptor("expandall")){

            public void run() {
                RepositoryExplorer.this.viewer.expandAll();
            }
        };
        this.copyAction = new Action(Messages.RepositoryExplorer_Copy){

            public void run() {
                IAdaptable[] objects = RepositoryExplorer.this.getSelectedObject(RepositoryExplorer.this.viewer.getSelection());
                if (objects.length != 0) {
                    Transfer[] transfer = new Transfer[objects.length];
                    int i = 0;
                    while (i < transfer.length) {
                        transfer[i] = RepositoryObjectTransfer.getInstance();
                        ++i;
                    }
                    Clipboard clipboard = new Clipboard(Display.getDefault());
                    try {
                        clipboard.setContents(new Object[]{objects}, new Transfer[]{RepositoryObjectTransfer.getInstance()});
                    }
                    finally {
                        clipboard.dispose();
                    }
                }
            }
        };
        this.copyAction.setImageDescriptor(imageRegistry.getDescriptor("copy_edit"));
        this.copyAction.setDisabledImageDescriptor(imageRegistry.getDescriptor("copy_edit_disabled"));
        this.copyAction.setId(ActionFactory.COPY.getId());
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.copyAction.setEnabled(false);
        this.pasteAction = new Action(Messages.RepositoryExplorer_Paste){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)RepositoryExplorer.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    RepositoryViewItem element = (RepositoryViewItem)selection.getFirstElement();
                    while (element.getParent() != null && !(element.getObject() instanceof IRepository)) {
                        element = (RepositoryViewItem)element.getParent();
                    }
                    IRepository destinationRepository = (IRepository)element.getObject();
                    Clipboard clipboard = new Clipboard(Display.getDefault());
                    try {
                        IAdaptable[] contents = (IAdaptable[])clipboard.getContents((Transfer)RepositoryObjectTransfer.getInstance());
                        if (contents.length != 0) {
                            IRepositoryService service = RepositoryExplorer.this.getRepositoryService();
                            RepositoryMoveJob job = new RepositoryMoveJob(service, contents, destinationRepository);
                            job.schedule();
                        }
                    }
                    finally {
                        clipboard.dispose();
                    }
                }
            }
        };
        this.pasteAction.setImageDescriptor(imageRegistry.getDescriptor("paste_edit"));
        this.pasteAction.setDisabledImageDescriptor(imageRegistry.getDescriptor("paste_edit_disabled"));
        this.pasteAction.setId(ActionFactory.PASTE.getId());
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.pasteAction.setEnabled(false);
        this.deleteAction = new Action(Messages.RepositoryExplorer_Delete){

            public void run() {
                final IAdaptable[] objects = RepositoryExplorer.this.getSelectedObject(RepositoryExplorer.this.viewer.getSelection());
                if (objects.length != 0) {
                    if (!MessageDialog.openConfirm((Shell)RepositoryExplorer.this.getViewSite().getShell(), (String)RepositoryExplorer.this.getPartName(), (String)Messages.RepositoryExplorer_DeleteConfirmMessage)) {
                        return;
                    }
                    final IRepositoryService service = RepositoryExplorer.this.getRepositoryService();
                    service.runInService(new IRepositoryRunnable(){

                        public IStatus run(IProgressMonitor monitor) throws Exception {
                            service.deleteAdaptable(objects);
                            return Status.OK_STATUS;
                        }
                    }, null);
                }
            }
        };
        this.deleteAction.setImageDescriptor(imageRegistry.getDescriptor("delete_edit"));
        this.deleteAction.setDisabledImageDescriptor(imageRegistry.getDescriptor("delete_edit_disabled"));
        this.deleteAction.setId(ActionFactory.DELETE.getId());
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.deleteAction.setEnabled(false);
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.expandAllAction);
        toolBarManager.add((IAction)this.collapseAllAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.refreshAction);
        site.getActionBars().setGlobalActionHandler(this.copyAction.getId(), (IAction)this.copyAction);
        site.getActionBars().setGlobalActionHandler(this.pasteAction.getId(), (IAction)this.pasteAction);
        site.getActionBars().setGlobalActionHandler(this.deleteAction.getId(), (IAction)this.deleteAction);
        site.getActionBars().updateActionBars();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 2);
        this.viewer.getTree().setHeaderVisible(false);
        this.viewer.getTree().setLinesVisible(false);
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RepositoryExplorer.this.viewer.getSelection();
                if (selection.size() == 1) {
                    Object element = selection.getFirstElement();
                    if (RepositoryExplorer.this.viewer.getExpandedState(element)) {
                        RepositoryExplorer.this.viewer.collapseToLevel(element, 1);
                    } else {
                        RepositoryExplorer.this.viewer.expandToLevel(element, 1);
                    }
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IAdaptable[] objects = RepositoryExplorer.this.getSelectedObject(event.getSelection());
                RepositoryExplorer.this.copyAction.setEnabled(objects.length != 0);
                RepositoryExplorer.this.deleteAction.setEnabled(objects.length != 0);
                RepositoryExplorer.this.getViewSite().getSelectionProvider().setSelection(event.getSelection());
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                try {
                    IHandlerService service = (IHandlerService)RepositoryExplorer.this.getSite().getService(IHandlerService.class);
                    service.executeCommand("org.eclipse.ui.file.open", null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        DragSource dragSource = new DragSource(this.viewer.getControl(), 3);
        dragSource.setTransfer(new Transfer[]{RepositoryObjectTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                event.doit = RepositoryExplorer.this.getSelectedObject(RepositoryExplorer.this.viewer.getSelection()).length != 0;
            }

            public void dragSetData(DragSourceEvent event) {
                if (RepositoryObjectTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = RepositoryExplorer.this.getSelectedObject(RepositoryExplorer.this.viewer.getSelection());
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.viewer.addDropSupport(3, new Transfer[]{RepositoryObjectTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return RepositoryObjectTransfer.getInstance().isSupportedType(transferType);
            }

            public boolean performDrop(Object data) {
                RepositoryViewItem element = (RepositoryViewItem)this.getCurrentTarget();
                while (element.getParent() != null && !(element.getObject() instanceof IRepository)) {
                    element = (RepositoryViewItem)element.getParent();
                }
                IRepository destinationRepository = (IRepository)element.getObject();
                IAdaptable[] contents = (IAdaptable[])data;
                if (contents.length != 0) {
                    IRepositoryService service = RepositoryExplorer.this.getRepositoryService();
                    RepositoryMoveJob job = new RepositoryMoveJob(service, contents, destinationRepository);
                    job.schedule();
                }
                return true;
            }
        });
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("group.new"));
                menuManager.add((IContributionItem)new GroupMarker("group.goto"));
                menuManager.add((IContributionItem)new Separator("group.open"));
                menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
                menuManager.add((IContributionItem)new Separator("group.show"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
                menuManager.add((IContributionItem)new GroupMarker("group.port"));
                menuManager.add((IContributionItem)new Separator("group.generate"));
                menuManager.add((IContributionItem)new Separator("group.search"));
                menuManager.add((IContributionItem)new Separator("group.build"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("group.properties"));
                menuManager.appendToGroup("group.show", (IAction)new Action(Messages.RepositoryExplorer_ExpandAll){

                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)RepositoryExplorer.this.viewer.getSelection();
                        Iterator iter = selection.iterator();
                        while (iter.hasNext()) {
                            RepositoryExplorer.this.viewer.expandToLevel(iter.next(), -1);
                        }
                    }
                });
                menuManager.appendToGroup("group.edit", (IAction)RepositoryExplorer.this.copyAction);
                menuManager.appendToGroup("group.edit", (IAction)RepositoryExplorer.this.pasteAction);
                menuManager.appendToGroup("group.reorganize", (IAction)RepositoryExplorer.this.deleteAction);
                boolean enablePaste = false;
                Clipboard clipboard = new Clipboard(Display.getDefault());
                try {
                    TransferData[] transfers = clipboard.getAvailableTypes();
                    int i = 0;
                    while (i < transfers.length) {
                        if (RepositoryObjectTransfer.getInstance().isSupportedType(transfers[i])) {
                            enablePaste = true;
                        }
                        ++i;
                    }
                }
                finally {
                    clipboard.dispose();
                }
                RepositoryExplorer.this.pasteAction.setEnabled(enablePaste);
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
        this.refreshJob.setUser(true);
        this.refreshJob.schedule();
        this.getRepositoryService().addRepositoryResourceListener(this.resourceListener);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void saveState(IMemento memento) {
        Object[] o = this.viewer.getExpandedElements();
        if (o != null && o.length != 0) {
            StringBuffer s = new StringBuffer();
            int i = 0;
            while (i < o.length) {
                if (i != 0) {
                    s.append(";");
                }
                s.append(o[i].hashCode());
                ++i;
            }
            memento.putString(K_EXPANDED, s.toString());
        }
        super.saveState(memento);
    }

    public void dispose() {
        this.getRepositoryService().removeRepositoryResourceListener(this.resourceListener);
        super.dispose();
    }

    protected IRepositoryService getRepositoryService() {
        try {
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class.getName());
            IRepositoryService service = (IRepositoryService)context.getService(serviceReference);
            context.ungetService(serviceReference);
            return service;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error reading repository service", (Throwable)e);
            UIActivator.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    protected IAdaptable[] getSelectedObject(ISelection selection) {
        ArrayList<IAdaptable> list = new ArrayList<IAdaptable>();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (!(((RepositoryViewItem)o).getObject() instanceof IAdaptable)) {
                    return new IAdaptable[0];
                }
                IAdaptable adaptable = (IAdaptable)((RepositoryViewItem)o).getObject();
                if (RepositoryObjectTransfer.checkMyType(adaptable)) {
                    list.add(adaptable);
                }
                ++n2;
            }
        }
        return list.toArray(new IAdaptable[list.size()]);
    }
}

