/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.repositories;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.internal.repositories.Messages;

public class RepositoryMoveJob
extends Job {
    private IAdaptable[] objects;
    private IRepositoryService service;
    private IRepository destinationRepository;

    public RepositoryMoveJob(IRepositoryService service, IAdaptable[] objects, IRepository destinationRepository) {
        super(Messages.RepositoryMoveJob_RepositoryMove);
        this.service = service;
        this.objects = objects;
        this.destinationRepository = destinationRepository;
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), this.objects.length * 10);
        int i = 0;
        while (i < this.objects.length) {
            final IAdaptable adaptable = this.objects[i];
            monitor.subTask(adaptable.toString());
            this.service.runInService(new IRepositoryRunnable(){

                public IStatus run(IProgressMonitor monitor) throws Exception {
                    RepositoryMoveJob.this.service.moveAdaptable(new IAdaptable[]{adaptable}, RepositoryMoveJob.this.destinationRepository);
                    return Status.OK_STATUS;
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            monitor.worked(10);
            ++i;
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

