/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.repositories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.views.IView;
import org.eclipsetrader.core.views.IViewChangeListener;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;
import org.eclipsetrader.core.views.IViewVisitor;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.ui.internal.repositories.Messages;
import org.eclipsetrader.ui.internal.repositories.OthersContainerObject;
import org.eclipsetrader.ui.internal.repositories.RepositoryViewItem;
import org.eclipsetrader.ui.internal.repositories.SecurityContainerObject;
import org.eclipsetrader.ui.internal.repositories.WatchListContainerObject;

public class RepositoryTree
implements IView {
    private IRepositoryService service;
    private RepositoryViewItem root;
    private SecurityContainerObject instrumentsContainer = new SecurityContainerObject(Messages.RepositoryTree_Instruments);
    private WatchListContainerObject watchlistsContainer = new WatchListContainerObject(Messages.RepositoryTree_Watchlists);
    private OthersContainerObject othersContainer = new OthersContainerObject(Messages.RepositoryTree_Others);

    public RepositoryTree(IRepositoryService service) {
        this.service = service;
        this.root = new RepositoryViewItem();
    }

    public void addViewChangeListener(IViewChangeListener listener) {
    }

    public void removeViewChangeListener(IViewChangeListener listener) {
    }

    public void dispose() {
    }

    public IViewItem[] getItems() {
        return this.root.getItems();
    }

    public void refresh() {
        IRepository[] iRepositoryArray = this.service.getRepositories();
        int n = iRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository repository = iRepositoryArray[n2];
            RepositoryViewItem element = this.root.getChild(repository);
            if (element == null) {
                element = this.root.createChild(repository);
            }
            this.visit(this.service, repository, element);
            ++n2;
        }
    }

    protected void visit(IRepositoryService service, IRepository repository, RepositoryViewItem parent) {
        ArrayList<IStoreObject> storeObjects = new ArrayList<IStoreObject>();
        storeObjects.addAll(Arrays.asList(service.getAllObjects()));
        Iterator iter = storeObjects.iterator();
        while (iter.hasNext()) {
            if (((IStoreObject)iter.next()).getStore().getRepository() == repository) continue;
            iter.remove();
        }
        ArrayList<IStoreObject> childObjects = new ArrayList<IStoreObject>();
        Iterator iter2 = storeObjects.iterator();
        while (iter2.hasNext()) {
            IStoreObject storeObject = (IStoreObject)iter2.next();
            if (!(storeObject instanceof ISecurity)) continue;
            childObjects.add(storeObject);
            iter2.remove();
        }
        RepositoryViewItem element = parent.getChild(this.instrumentsContainer);
        if (element == null) {
            element = parent.createChild(this.instrumentsContainer);
        }
        this.visit(childObjects, element);
        childObjects = new ArrayList();
        Iterator iter3 = storeObjects.iterator();
        while (iter3.hasNext()) {
            IStoreObject storeObject = (IStoreObject)iter3.next();
            if (!(storeObject instanceof IWatchList)) continue;
            childObjects.add(storeObject);
            iter3.remove();
        }
        element = parent.getChild(this.watchlistsContainer);
        if (element == null) {
            element = parent.createChild(this.watchlistsContainer);
        }
        this.visit(childObjects, element);
        element = parent.getChild(this.othersContainer);
        if (element == null) {
            element = parent.createChild(this.othersContainer);
        }
        this.visit(storeObjects, element);
    }

    protected void visit(List<?> objects, RepositoryViewItem parent) {
        for (Object obj : objects) {
            if (parent.hasChild(obj)) continue;
            parent.createChild(obj);
        }
        Iterator<RepositoryViewItem> iter = parent.iterator();
        while (iter.hasNext()) {
            if (objects.contains(iter.next().getObject())) continue;
            iter.remove();
        }
    }

    public void accept(IViewVisitor visitor) {
        if (visitor.visit((IView)this)) {
            IViewItem[] iViewItemArray = this.getItems();
            int n = iViewItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewItem viewItem = iViewItemArray[n2];
                viewItem.accept((IViewItemVisitor)visitor);
                ++n2;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }
}

