/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipsetrader.core.feed.FeedProperties;
import org.eclipsetrader.ui.internal.securities.Messages;

public class FeedPropertiesControl {
    private Composite container;
    private TreeViewer viewer;
    private FeedProperties properties;

    public FeedPropertiesControl(Composite parent) {
        this.container = new Composite(parent, 0);
        TreeColumnLayout tableLayout = new TreeColumnLayout();
        this.container.setLayout((Layout)tableLayout);
        this.viewer = new TreeViewer(this.container, 2818);
        TreeColumn treeColumn = new TreeColumn(this.viewer.getTree(), 0);
        treeColumn.setText(Messages.FeedPropertiesControl_Property);
        tableLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(35));
        treeColumn = new TreeColumn(this.viewer.getTree(), 0);
        treeColumn.setText(Messages.FeedPropertiesControl_Value);
        tableLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(65));
        this.viewer.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new PropertiesContentProvider());
        this.viewer.setSorter(new ViewerSorter());
        String[] stringArray = new String[2];
        stringArray[1] = "value";
        this.viewer.setColumnProperties(stringArray);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)this.viewer.getTree());
        this.viewer.setCellEditors(cellEditorArray);
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return element instanceof PropertyElement && "value".equals(property);
            }

            public Object getValue(Object element, String property) {
                if (element instanceof PropertyElement && "value".equals(property)) {
                    return ((PropertyElement)element).getValue() != null ? ((PropertyElement)element).getValue() : "";
                }
                return null;
            }

            public void modify(Object object, String property, Object value) {
                PropertyElement element = (PropertyElement)(object instanceof TreeItem ? ((TreeItem)object).getData() : object);
                element.setValue("".equals(value) ? null : value.toString());
                FeedPropertiesControl.this.viewer.update((Object)element, new String[]{property});
            }
        });
        this.viewer.setInput((Object)this.buildInput());
        this.viewer.expandAll();
    }

    public Control getControl() {
        return this.container;
    }

    public Tree getTree() {
        return this.viewer.getTree();
    }

    public Object getLayoutData() {
        return this.container.getLayoutData();
    }

    public void setLayoutData(Object layoutData) {
        this.container.setLayoutData(layoutData);
    }

    protected PropertyElementContainer[] buildInput() {
        HashMap<String, PropertyElementContainer> containers = new HashMap<String, PropertyElementContainer>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipsetrader.core.connectors");
        if (extensionPoint != null) {
            IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String name = configElements[j].getDeclaringExtension().getLabel();
                if (name == null || name.equals("")) {
                    name = configElements[j].getDeclaringExtension().getContributor().getName();
                }
                if ("property".equals(configElements[j].getName())) {
                    PropertyElementContainer container = (PropertyElementContainer)containers.get(name);
                    if (container == null) {
                        container = new PropertyElementContainer(name);
                        containers.put(name, container);
                    }
                    container.createChild(configElements[j].getAttribute("id"), configElements[j].getAttribute("name"));
                }
                ++j;
            }
        }
        return containers.values().toArray(new PropertyElementContainer[containers.values().size()]);
    }

    public void setProperties(FeedProperties properties) {
        PropertyElementContainer[] input;
        this.properties = properties;
        PropertyElementContainer[] propertyElementContainerArray = input = (PropertyElementContainer[])this.viewer.getInput();
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyElementContainer container = propertyElementContainerArray[n2];
            PropertyElement[] propertyElementArray = container.getChilds();
            int n3 = propertyElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                PropertyElement element = propertyElementArray[n4];
                element.setValue(properties != null ? properties.getProperty(element.getId()) : null);
                ++n4;
            }
            ++n2;
        }
        this.viewer.refresh();
    }

    public FeedProperties getProperties() {
        if (this.properties == null) {
            this.properties = new FeedProperties();
        }
        if (this.properties != null) {
            PropertyElementContainer[] input;
            PropertyElementContainer[] propertyElementContainerArray = input = (PropertyElementContainer[])this.viewer.getInput();
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyElementContainer container = propertyElementContainerArray[n2];
                PropertyElement[] propertyElementArray = container.getChilds();
                int n3 = propertyElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    PropertyElement element = propertyElementArray[n4];
                    this.properties.setProperty(element.getId(), element.getValue());
                    ++n4;
                }
                ++n2;
            }
        }
        return this.properties.getPropertyIDs().length != 0 ? this.properties : null;
    }

    public class PropertiesContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PropertyElementContainer) {
                return ((PropertyElementContainer)parentElement).getChilds();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof PropertyElement) {
                return ((PropertyElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PropertyElementContainer;
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    public class PropertiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private Font containerFont;

        public PropertiesLabelProvider() {
            FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
            if (fontData != null && fontData.length != 0) {
                this.containerFont = new Font((Device)Display.getDefault(), fontData[0].getName(), fontData[0].getHeight(), 1);
            }
        }

        public void dispose() {
            if (this.containerFont != null) {
                this.containerFont.dispose();
            }
            super.dispose();
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return element.toString();
                }
                case 1: {
                    if (!(element instanceof PropertyElement)) break;
                    String value = ((PropertyElement)element).getValue();
                    return value != null ? value : Messages.FeedPropertiesControl_Default;
                }
            }
            return "";
        }

        public Font getFont(Object element) {
            if (element instanceof PropertyElementContainer) {
                return this.containerFont;
            }
            return null;
        }
    }

    public class PropertyElement {
        private String id;
        private String name;
        private String value;
        private PropertyElementContainer parent;

        public PropertyElement(String id, String name, PropertyElementContainer parent) {
            this.id = id;
            this.name = name;
            this.parent = parent;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public PropertyElementContainer getParent() {
            return this.parent;
        }

        public String toString() {
            return this.name;
        }
    }

    public class PropertyElementContainer {
        private String name;
        private Map<String, PropertyElement> childs = new HashMap<String, PropertyElement>();

        public PropertyElementContainer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public PropertyElement[] getChilds() {
            Collection<PropertyElement> c = this.childs.values();
            return c.toArray(new PropertyElement[c.size()]);
        }

        public PropertyElement createChild(String id, String name) {
            PropertyElement element = this.childs.get(id);
            if (element == null) {
                element = new PropertyElement(id, name, this);
                this.childs.put(id, element);
            }
            return element;
        }

        public String toString() {
            return this.name;
        }
    }
}

