/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities.properties;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.feed.FeedIdentifier;
import org.eclipsetrader.core.feed.FeedProperties;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.Security;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.securities.FeedPropertiesControl;
import org.eclipsetrader.ui.internal.securities.properties.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class IdentifierProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text name;
    private Label propertiesLabel;
    private FeedPropertiesControl properties;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            IdentifierProperties.this.updateSymbolSelection();
            IdentifierProperties.this.setValid(IdentifierProperties.this.isValid());
        }
    };

    public IdentifierProperties() {
        this.setTitle(Messages.IdentifierProperties_Identifier);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.IdentifierProperties_IdentifierName);
        this.name = new Text(content, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.propertiesLabel = new Label(content, 0);
        this.propertiesLabel.setText(Messages.IdentifierProperties_Properties);
        this.propertiesLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.properties = new FeedPropertiesControl(content);
        this.properties.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)this.properties.getControl().getLayoutData()).heightHint = this.properties.getTree().getItemHeight() * 15;
        this.performDefaults();
        this.name.addModifyListener(this.modifyListener);
        return content;
    }

    protected void performDefaults() {
        ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        IFeedIdentifier feedIdentifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
        if (feedIdentifier != null) {
            this.name.setText(feedIdentifier.getSymbol());
        }
        FeedProperties feedProperties = (FeedProperties)feedIdentifier.getAdapter(FeedProperties.class);
        this.properties.setProperties(feedProperties);
        this.updateSymbolSelection();
        super.performDefaults();
    }

    protected void applyChanges() {
        Security security = (Security)this.getElement().getAdapter(Security.class);
        if (security != null) {
            if (this.name.getText().equals("")) {
                security.setIdentifier(null);
            } else {
                IFeedIdentifier feedIdentifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
                if (feedIdentifier == null && (feedIdentifier = this.getRepositoryService().getFeedIdentifierFromSymbol(this.name.getText())) == null) {
                    feedIdentifier = new FeedIdentifier(this.name.getText(), new FeedProperties());
                }
                if (feedIdentifier instanceof FeedIdentifier) {
                    ((FeedIdentifier)feedIdentifier).setSymbol(this.name.getText());
                    ((FeedIdentifier)feedIdentifier).setProperties(this.properties.getProperties());
                }
                security.setIdentifier(feedIdentifier);
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }

    protected void performApply() {
        this.applyChanges();
        final ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        final IRepositoryService service = this.getRepositoryService();
        service.runInService(new IRepositoryRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                service.saveAdaptable(new IAdaptable[]{security});
                return Status.OK_STATUS;
            }
        }, null);
    }

    protected void updateSymbolSelection() {
        boolean hasIdentifier = !this.name.getText().equals("");
        this.propertiesLabel.setEnabled(hasIdentifier);
        this.properties.getTree().setEnabled(hasIdentifier);
    }

    protected IMarket[] getMarkets() {
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMarketService.class.getName());
        if (serviceReference != null) {
            IMarketService marketService = (IMarketService)context.getService(serviceReference);
            return marketService.getMarkets();
        }
        return new IMarket[0];
    }

    protected IRepositoryService getRepositoryService() {
        return UIActivator.getDefault().getRepositoryService();
    }
}

