/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities.properties;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.securities.properties.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MarketsProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Label marketsLabel;
    private CheckboxTableViewer markets;

    public MarketsProperties() {
        this.setTitle(Messages.MarketsProperties_Markets);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        this.marketsLabel = new Label(content, 0);
        this.marketsLabel.setText(Messages.MarketsProperties_Markets2);
        this.marketsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.markets = CheckboxTableViewer.newCheckList((Composite)content, (int)2820);
        this.markets.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)this.markets.getControl().getLayoutData()).heightHint = this.markets.getTable().getItemHeight() * 4 + this.markets.getTable().getBorderWidth() * 2;
        this.markets.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.markets.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.markets.setSorter(new ViewerSorter());
        this.markets.setInput((Object)this.getMarkets());
        this.markets.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    Object[] elements = MarketsProperties.this.markets.getCheckedElements();
                    int i = 0;
                    while (i < elements.length) {
                        if (elements[i] != event.getElement()) {
                            MarketsProperties.this.markets.setChecked(elements[i], false);
                        }
                        ++i;
                    }
                }
            }
        });
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        IMarket[] iMarketArray = this.getMarkets();
        int n = iMarketArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarket market = iMarketArray[n2];
            this.markets.setChecked((Object)market, market.hasMember(security));
            ++n2;
        }
        super.performDefaults();
    }

    protected void applyChanges() {
        ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        IMarket[] iMarketArray = this.getMarkets();
        int n = iMarketArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarket market = iMarketArray[n2];
            if (this.markets.getChecked((Object)market)) {
                market.addMembers(new ISecurity[]{security});
            } else {
                market.removeMembers(new ISecurity[]{security});
            }
            ++n2;
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }

    protected void performApply() {
        this.applyChanges();
        super.performApply();
    }

    protected IMarket[] getMarkets() {
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMarketService.class.getName());
        if (serviceReference != null) {
            IMarketService marketService = (IMarketService)context.getService(serviceReference);
            return marketService.getMarkets();
        }
        return new IMarket[0];
    }

    protected IRepositoryService getRepositoryService() {
        return UIActivator.getDefault().getRepositoryService();
    }
}

