/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities.wizards;

import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipsetrader.core.instruments.CurrencyExchange;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.securities.wizards.CurrencyExchangePage;
import org.eclipsetrader.ui.internal.securities.wizards.IdentifierPage;
import org.eclipsetrader.ui.internal.securities.wizards.MarketsPage;
import org.eclipsetrader.ui.internal.securities.wizards.Messages;

public class CurrencyExchangeWizard
extends Wizard
implements INewWizard {
    private Image image;
    private CurrencyExchangePage namePage;
    private IdentifierPage identifierPage;
    private MarketsPage marketsPage;

    public CurrencyExchangeWizard() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)UIActivator.getDefault().getBundle().getResource("icons/wizban/newfile_wiz.gif"));
        this.image = descriptor.createImage();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }

    public String getWindowTitle() {
        return Messages.CurrencyExchangeWizard_NewCurrencyExchange;
    }

    public Image getDefaultPageImage() {
        return this.image;
    }

    public void addPages() {
        this.namePage = new CurrencyExchangePage();
        this.addPage((IWizardPage)this.namePage);
        this.identifierPage = new IdentifierPage();
        this.addPage((IWizardPage)this.identifierPage);
        this.marketsPage = new MarketsPage();
        this.addPage((IWizardPage)this.marketsPage);
    }

    public boolean performFinish() {
        IRepository repository = this.namePage.getRepository();
        CurrencyExchange resource = new CurrencyExchange(this.namePage.getSecurityName(), this.identifierPage.getFeedIdentifier(), this.namePage.getFromCurrency(), this.namePage.getToCurrency(), 1.0);
        IMarket[] markets = this.marketsPage.getSelectedMarkets();
        final IRepositoryService service = UIActivator.getDefault().getRepositoryService();
        service.runInService(new IRepositoryRunnable((ISecurity)resource, repository, markets){
            private final /* synthetic */ ISecurity val$resource;
            private final /* synthetic */ IRepository val$repository;
            private final /* synthetic */ IMarket[] val$markets;
            {
                this.val$resource = iSecurity;
                this.val$repository = iRepository;
                this.val$markets = iMarketArray;
            }

            public IStatus run(IProgressMonitor monitor) throws Exception {
                service.moveAdaptable(new IAdaptable[]{this.val$resource}, this.val$repository);
                int i = 0;
                while (i < this.val$markets.length) {
                    this.val$markets[i].addMembers(new ISecurity[]{this.val$resource});
                    ++i;
                }
                return Status.OK_STATUS;
            }
        }, null);
        return true;
    }
}

