/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import org.eclipse.osgi.util.NLS;
import org.eclipsetrader.core.trading.AlertEvent;
import org.eclipsetrader.core.trading.IAlert;
import org.eclipsetrader.core.trading.IAlertListener;
import org.eclipsetrader.ui.INotification;
import org.eclipsetrader.ui.INotificationService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.trading.AlertNotification;
import org.eclipsetrader.ui.internal.trading.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class AlertNotificationListener
implements IAlertListener {
    public void alertTriggered(AlertEvent event) {
        IAlert[] alerts = event.getTriggeredAlerts();
        if (alerts.length == 0) {
            return;
        }
        AlertNotification notification = new AlertNotification();
        notification.setSecurity(event.getInstrument());
        String description = alerts[0].getDescription();
        if (alerts.length > 1) {
            description = String.valueOf(description) + NLS.bind((String)Messages.AlertNotificationListener_MoreAlerts, (Object[])new Object[]{String.valueOf(alerts.length - 1)});
        }
        notification.setDescription(description);
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(INotificationService.class.getName());
        if (serviceReference != null) {
            INotificationService notificationService = (INotificationService)context.getService(serviceReference);
            notificationService.popupNotification(new INotification[]{notification});
        }
        context.ungetService(serviceReference);
    }
}

