/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.trading.Messages;

public class ConfigurationElementsViewer {
    private Composite control;
    private TableViewer available;
    private Button right;
    private Button allRight;
    private Button allLeft;
    private Button left;
    private TableViewer selected;
    private Button up;
    private Button down;
    private Image rightImage = UIActivator.getImageDescriptor("icons/etool16/right.gif").createImage();
    private Image allRightImage = UIActivator.getImageDescriptor("icons/etool16/all-right.gif").createImage();
    private Image allLeftImage = UIActivator.getImageDescriptor("icons/etool16/all-left.gif").createImage();
    private Image leftImage = UIActivator.getImageDescriptor("icons/etool16/left.gif").createImage();
    private Image upImage = UIActivator.getImageDescriptor("icons/etool16/up.gif").createImage();
    private Image downImage = UIActivator.getImageDescriptor("icons/etool16/down.gif").createImage();
    private List<IConfigurationElement> availableList = new ArrayList<IConfigurationElement>();
    private List<IConfigurationElement> selectedList = new ArrayList<IConfigurationElement>();
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (ConfigurationElementsViewer.this.rightImage != null) {
                ConfigurationElementsViewer.this.rightImage.dispose();
            }
            if (ConfigurationElementsViewer.this.allRightImage != null) {
                ConfigurationElementsViewer.this.allRightImage.dispose();
            }
            if (ConfigurationElementsViewer.this.allLeftImage != null) {
                ConfigurationElementsViewer.this.allLeftImage.dispose();
            }
            if (ConfigurationElementsViewer.this.leftImage != null) {
                ConfigurationElementsViewer.this.leftImage.dispose();
            }
            if (ConfigurationElementsViewer.this.upImage != null) {
                ConfigurationElementsViewer.this.upImage.dispose();
            }
            if (ConfigurationElementsViewer.this.downImage != null) {
                ConfigurationElementsViewer.this.downImage.dispose();
            }
        }
    };

    public ConfigurationElementsViewer(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.control.setLayout((Layout)gridLayout);
        this.createLabels(this.control);
        this.createInputViewer(this.control);
        this.createSelectionViewer(this.control);
        this.control.addDisposeListener(this.disposeListener);
        this.updateControlsEnablement();
    }

    public Composite getControl() {
        return this.control;
    }

    protected void createLabels(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.ConfigurationElementsViewer_AvailableColumnsLabel);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label(parent, 0);
        label.setText(Messages.ConfigurationElementsViewer_ShownColumnsLabel);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    protected void createInputViewer(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        control.setLayout((Layout)gridLayout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)control.getLayoutData()).widthHint = 200;
        this.available = new TableViewer(control, 67586);
        this.available.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.available.getControl().getLayoutData()).heightHint = this.available.getTable().getItemHeight() * 15 + this.available.getTable().getBorderWidth() * 2;
        this.available.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IConfigurationElement)element).getAttribute("name");
            }
        });
        this.available.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.available.setSorter(new ViewerSorter());
        this.available.setInput(this.availableList);
        this.available.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationElementsViewer.this.updateControlsEnablement();
            }
        });
        this.createInputButtons(control);
    }

    protected void createInputButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.right = new Button(buttons, 8);
        this.right.setImage(this.rightImage);
        this.right.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ConfigurationElementsViewer.this.available.getSelection();
                ConfigurationElementsViewer.this.selectedList.addAll(selection.toList());
                ConfigurationElementsViewer.this.selected.refresh();
                ConfigurationElementsViewer.this.availableList.removeAll(selection.toList());
                ConfigurationElementsViewer.this.available.refresh();
                ConfigurationElementsViewer.this.updateControlsEnablement();
            }
        });
        this.allRight = new Button(buttons, 8);
        this.allRight.setImage(this.allRightImage);
        this.allRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationElementsViewer.this.selectedList.addAll(ConfigurationElementsViewer.this.availableList);
                ConfigurationElementsViewer.this.selected.refresh();
                ConfigurationElementsViewer.this.availableList.clear();
                ConfigurationElementsViewer.this.available.refresh();
                ConfigurationElementsViewer.this.updateControlsEnablement();
            }
        });
        this.allLeft = new Button(buttons, 8);
        this.allLeft.setImage(this.allLeftImage);
        this.allLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationElementsViewer.this.availableList.addAll(ConfigurationElementsViewer.this.selectedList);
                ConfigurationElementsViewer.this.available.refresh();
                ConfigurationElementsViewer.this.selectedList.clear();
                ConfigurationElementsViewer.this.selected.refresh();
                ConfigurationElementsViewer.this.updateControlsEnablement();
            }
        });
        this.left = new Button(buttons, 8);
        this.left.setImage(this.leftImage);
        this.left.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ConfigurationElementsViewer.this.selected.getSelection();
                ConfigurationElementsViewer.this.selectedList.removeAll(selection.toList());
                ConfigurationElementsViewer.this.selected.refresh();
                ConfigurationElementsViewer.this.availableList.addAll(selection.toList());
                ConfigurationElementsViewer.this.available.refresh();
                ConfigurationElementsViewer.this.updateControlsEnablement();
            }
        });
    }

    protected void createSelectionViewer(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        control.setLayout((Layout)gridLayout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)control.getLayoutData()).widthHint = 200;
        this.selected = new TableViewer(control, 67586);
        this.selected.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.selected.getControl().getLayoutData()).heightHint = this.selected.getTable().getItemHeight() * 15 + this.selected.getTable().getBorderWidth() * 2;
        this.selected.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IConfigurationElement)element).getAttribute("name");
            }
        });
        this.selected.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selected.setInput(this.selectedList);
        this.selected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationElementsViewer.this.updateControlsEnablement();
            }
        });
        this.createSelectionButtons(control);
    }

    protected void moveSelectionUp(Object[] s) {
        ArrayList<IConfigurationElement> l = new ArrayList<IConfigurationElement>();
        int index = 999999;
        int i = 0;
        while (i < s.length) {
            index = Math.min(index, this.selectedList.indexOf(s[i]));
            l.add((IConfigurationElement)s[i]);
            ++i;
        }
        if (index > 0) {
            this.selectedList.removeAll(l);
            this.selectedList.addAll(--index, l);
            this.selected.refresh();
        }
    }

    protected void moveSelectionDown(Object[] s) {
        ArrayList<IConfigurationElement> l = new ArrayList<IConfigurationElement>();
        int index = -1;
        int i = 0;
        while (i < s.length) {
            index = Math.max(index, this.selectedList.indexOf(s[i]));
            l.add((IConfigurationElement)s[i]);
            ++i;
        }
        if (index < this.selectedList.size() - 1) {
            ++index;
            this.selectedList.removeAll(l);
            this.selectedList.addAll(index -= l.size() - 1, l);
            this.selected.refresh();
        }
    }

    protected void createSelectionButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.up = new Button(buttons, 8);
        this.up.setImage(this.upImage);
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ConfigurationElementsViewer.this.selected.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)ConfigurationElementsViewer.this.selected.getSelection()).toArray();
                    ConfigurationElementsViewer.this.moveSelectionUp(s);
                    ConfigurationElementsViewer.this.updateControlsEnablement();
                }
            }
        });
        this.down = new Button(buttons, 8);
        this.down.setImage(this.downImage);
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ConfigurationElementsViewer.this.selected.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)ConfigurationElementsViewer.this.selected.getSelection()).toArray();
                    ConfigurationElementsViewer.this.moveSelectionDown(s);
                    ConfigurationElementsViewer.this.updateControlsEnablement();
                }
            }
        });
    }

    public void setAvailableElements(IConfigurationElement[] factories) {
        this.availableList.clear();
        this.availableList.addAll(Arrays.asList(factories));
        this.availableList.removeAll(this.selectedList);
        this.available.refresh();
        this.updateControlsEnablement();
    }

    public void setSelectedElements(IConfigurationElement[] columns) {
        this.selectedList.clear();
        this.selectedList.addAll(Arrays.asList(columns));
        this.selected.refresh();
        this.availableList.removeAll(this.selectedList);
        this.available.refresh();
        this.updateControlsEnablement();
    }

    public IConfigurationElement[] getSelectedElements() {
        return this.selectedList.toArray(new IConfigurationElement[this.selectedList.size()]);
    }

    protected void updateControlsEnablement() {
        this.right.setEnabled(!this.available.getSelection().isEmpty());
        this.allRight.setEnabled(this.availableList.size() != 0);
        this.left.setEnabled(!this.selected.getSelection().isEmpty());
        this.allLeft.setEnabled(this.selectedList.size() != 0);
        int upperIndex = -1;
        int lowerIndex = 999999;
        Object[] s = ((IStructuredSelection)this.selected.getSelection()).toArray();
        int i = 0;
        while (i < s.length) {
            upperIndex = Math.max(upperIndex, this.selectedList.indexOf(s[i]));
            lowerIndex = Math.min(lowerIndex, this.selectedList.indexOf(s[i]));
            ++i;
        }
        this.up.setEnabled(!this.selected.getSelection().isEmpty() && upperIndex > 0);
        this.down.setEnabled(!this.selected.getSelection().isEmpty() && lowerIndex < this.selectedList.size() - 1);
    }
}

