/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.feed.IFeedService;
import org.eclipsetrader.core.internal.trading.MarketBroker;
import org.eclipsetrader.core.internal.trading.MarketBrokerAdapterFactory;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.trading.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MarketTradingPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    ComboViewer brokerCombo;

    public MarketTradingPage() {
        this.setTitle(Messages.MarketTradingPage_Title);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        IBroker broker;
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.MarketTradingPage_BrokerLabel);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.brokerCombo = new ComboViewer(content, 8);
        this.brokerCombo.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.brokerCombo.getCombo().setVisibleItemCount(15);
        this.brokerCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IBroker)) {
                    return Messages.MarketTradingPage_None_Element;
                }
                return ((IBroker)element).getName();
            }
        });
        this.brokerCombo.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof IBroker) {
                    return 1;
                }
                return 0;
            }
        });
        this.brokerCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<Object> brokers = new ArrayList<Object>();
        brokers.add(new Object());
        if (this.getTradingService() != null) {
            brokers.addAll(Arrays.asList(this.getTradingService().getBrokers()));
        }
        this.brokerCombo.setInput((Object)brokers.toArray());
        this.brokerCombo.setSelection((ISelection)new StructuredSelection(brokers.get(0)));
        IMarket market = (IMarket)this.getElement().getAdapter(IMarket.class);
        if (market != null && (broker = (IBroker)market.getAdapter(IBroker.class)) != null) {
            if (!brokers.contains(broker)) {
                brokers.add(broker);
                this.brokerCombo.setInput((Object)brokers.toArray());
            }
            this.brokerCombo.setSelection((ISelection)new StructuredSelection((Object)broker));
        }
        return content;
    }

    public boolean isValid() {
        return true;
    }

    public boolean performOk() {
        if (this.isControlCreated()) {
            IMarket market = (IMarket)this.getElement().getAdapter(IMarket.class);
            MarketBrokerAdapterFactory adapter = (MarketBrokerAdapterFactory)AdapterManager.getDefault().getAdapter((Object)market, MarketBrokerAdapterFactory.class);
            Object s = ((IStructuredSelection)this.brokerCombo.getSelection()).getFirstElement();
            if (s instanceof IBroker) {
                MarketBroker marketBroker = new MarketBroker(market);
                marketBroker.setConnector(s instanceof IBroker ? (IBroker)s : null);
                adapter.addOverride(marketBroker);
            } else {
                adapter.clearOverride(market);
            }
        }
        return super.performOk();
    }

    protected IFeedService getFeedService() {
        if (UIActivator.getDefault() == null) {
            return null;
        }
        try {
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IFeedService.class.getName());
            IFeedService service = (IFeedService)context.getService(serviceReference);
            context.ungetService(serviceReference);
            return service;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, Messages.MarketTradingPage_ErrorReadingFeedService, (Throwable)e);
            UIActivator.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    protected ITradingService getTradingService() {
        if (UIActivator.getDefault() == null) {
            return null;
        }
        try {
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(ITradingService.class.getName());
            ITradingService service = (ITradingService)context.getService(serviceReference);
            context.ungetService(serviceReference);
            return service;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, Messages.MarketTradingPage_ErrorReadingTradingService, (Throwable)e);
            UIActivator.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }
}

