/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import java.text.NumberFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IOrderRoute;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IOrderType;
import org.eclipsetrader.core.trading.IOrderValidity;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.core.trading.Order;
import org.eclipsetrader.ui.Util;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.trading.Messages;

public class OrderDialog
extends TitleAreaDialog {
    Text symbol;
    Label symbolDescription;
    ComboViewer sideCombo;
    Text quantity;
    ComboViewer typeCombo;
    Text price;
    ComboViewer brokerCombo;
    ComboViewer accountCombo;
    ComboViewer routeCombo;
    ComboViewer validityCombo;
    CDateTime expireDate;
    Text orderReference;
    Label summaryLabel;
    private ISecurity security;
    private IBroker broker;
    private IAccount account;
    private Long position;
    private Double limitPrice;
    private IOrderSide orderSide;
    private ITradingService tradingService;
    NumberFormat numberFormat;
    NumberFormat priceFormat;
    NumberFormat totalPriceFormat;
    private ISelectionChangedListener orderTypeSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            OrderDialog.this.price.setEnabled(selection.getFirstElement() == IOrderType.Limit || selection.getFirstElement() == IOrderType.Stop || selection.getFirstElement() == IOrderType.StopLimit);
            OrderDialog.this.updateSummary();
            OrderDialog.this.getButton(0).setEnabled(OrderDialog.this.isValid());
        }
    };

    public OrderDialog(Shell parentShell, ITradingService tradingService) {
        super(parentShell);
        this.tradingService = tradingService;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(0);
        this.numberFormat.setGroupingUsed(true);
        this.priceFormat = NumberFormat.getInstance();
        this.priceFormat.setMinimumFractionDigits(1);
        this.priceFormat.setMaximumFractionDigits(4);
        this.priceFormat.setGroupingUsed(true);
        this.totalPriceFormat = NumberFormat.getInstance();
        this.totalPriceFormat.setMinimumFractionDigits(2);
        this.totalPriceFormat.setMaximumFractionDigits(2);
        this.totalPriceFormat.setGroupingUsed(true);
    }

    public void setSecurity(ISecurity security) {
        this.security = security;
    }

    public void setBroker(IBroker broker) {
        this.broker = broker;
    }

    public void setAccount(IAccount account) {
        this.account = account;
    }

    public void setPosition(Long position) {
        this.position = position;
    }

    public void setLimitPrice(Double limitPrice) {
        this.limitPrice = limitPrice;
    }

    public void setOrderSide(IOrderSide orderSide) {
        this.orderSide = orderSide;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.OrderDialog_Text);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Messages.OrderDialog_Title);
        this.setMessage(Messages.OrderDialog_Message);
        this.getButton(0).setEnabled(this.isValid());
        return control;
    }

    protected boolean isValid() {
        if (this.symbol.getText().equals("")) {
            return false;
        }
        try {
            long quantity = this.numberFormat.parse(this.quantity.getText()).longValue();
            if (quantity <= 0L) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        IOrderType orderType = (IOrderType)((IStructuredSelection)this.typeCombo.getSelection()).getFirstElement();
        if (orderType == IOrderType.Limit || orderType == IOrderType.Stop || orderType == IOrderType.StopLimit) {
            try {
                double price = this.priceFormat.parse(this.price.getText()).doubleValue();
                if (price <= 0.0) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createContractDescriptionGroup(composite);
        this.createOrderDescriptionGroup(composite);
        this.createMiscellaneousGroup(composite);
        this.createSummaryGroup(composite);
        this.setInitialParameters();
        this.updateSummary();
        this.addListeners();
        this.quantity.setFocus();
        return composite;
    }

    protected void createContractDescriptionGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Label label = new Label(composite, 0);
        label.setText(Messages.OrderDialog_SymbolLabel);
        this.symbol = new Text(composite, 2048);
        this.symbol.setLayoutData((Object)new GridData(this.convertWidthInCharsToPixels(18), -1));
        this.symbolDescription = new Label(composite, 0);
        this.symbolDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void createOrderDescriptionGroup(Composite parent) {
        Group content = new Group(parent, 0);
        content.setText(Messages.OrderDialog_OrderDescriptionGroup);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setLayoutData((Object)new GridData(4, 4, false, false));
        Label label = new Label((Composite)content, 0);
        label.setText(Messages.OrderDialog_ActionLabel);
        this.sideCombo = new ComboViewer((Composite)content, 2060);
        this.sideCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sideCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sideCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        label = new Label((Composite)content, 0);
        label.setText(Messages.OrderDialog_QuantityLabel);
        this.quantity = new Text((Composite)content, 2048);
        this.quantity.setLayoutData((Object)new GridData(this.convertWidthInCharsToPixels(18), -1));
        ((GridData)this.quantity.getLayoutData()).horizontalAlignment = 4;
        label = new Label((Composite)content, 0);
        label.setText(Messages.OrderDialog_OrderTypeLabel);
        this.typeCombo = new ComboViewer((Composite)content, 2060);
        this.typeCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.typeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        label = new Label((Composite)content, 0);
        label.setText(Messages.OrderDialog_LimitPriceLabel);
        this.price = new Text((Composite)content, 2048);
        this.price.setLayoutData((Object)new GridData(this.convertWidthInCharsToPixels(18), -1));
        ((GridData)this.price.getLayoutData()).horizontalAlignment = 4;
        this.price.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                try {
                    double n = OrderDialog.this.priceFormat.parse(((Text)event.widget).getText()).doubleValue();
                    ((Text)event.widget).setText(OrderDialog.this.priceFormat.format(n));
                }
                catch (Exception exception) {}
            }
        });
        label = new Label((Composite)content, 0);
        label.setText(Messages.OrderDialog_BrokerLabel);
        this.brokerCombo = new ComboViewer((Composite)content, 2060);
        this.brokerCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.brokerCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.brokerCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IBroker)element).getName();
            }
        });
        this.brokerCombo.setSorter(new ViewerSorter());
        this.brokerCombo.setInput((Object)this.tradingService.getBrokers());
        label = new Label((Composite)content, 0);
        label.setText(Messages.OrderDialog_Account);
        this.accountCombo = new ComboViewer((Composite)content, 2060);
        this.accountCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.accountCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.accountCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IAccount)element).getDescription();
            }
        });
        this.accountCombo.setSorter(new ViewerSorter());
        this.accountCombo.getControl().setEnabled(false);
        label = new Label((Composite)content, 0);
        label.setText(Messages.OrderDialog_RouteLabel);
        this.routeCombo = new ComboViewer((Composite)content, 2060);
        this.routeCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.routeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.routeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.routeCombo.setSorter(new ViewerSorter());
    }

    protected void createMiscellaneousGroup(Composite parent) {
        Group content = new Group(parent, 0);
        content.setText(Messages.OrderDialog_MiscLabel);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setLayoutData((Object)new GridData(4, 4, false, false));
        Label label = new Label((Composite)content, 0);
        label.setText(Messages.OrderDialog_TimeInForceLabel);
        this.validityCombo = new ComboViewer((Composite)content, 2060);
        this.validityCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.validityCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.validityCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        label = new Label((Composite)content, 0);
        label.setText(Messages.OrderDialog_ExpireLabel);
        this.expireDate = new CDateTime((Composite)content, 34603011);
        this.expireDate.setPattern(Util.getDateFormatPattern());
        this.expireDate.setSelection(new Date());
        this.expireDate.setEnabled(false);
        label = new Label((Composite)content, 0);
        label.setText(Messages.OrderDialog_ReferenceLabel);
        this.orderReference = new Text((Composite)content, 2048);
        this.orderReference.setLayoutData((Object)new GridData(this.convertWidthInCharsToPixels(40), -1));
    }

    protected void createSummaryGroup(Composite parent) {
        Group content = new Group(parent, 0);
        content.setText(Messages.OrderDialog_SummaryGroup);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.summaryLabel = new Label((Composite)content, 0);
        this.summaryLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    void setInitialParameters() {
        if (this.security != null) {
            this.symbol.setText(this.getSecuritySymbol(this.security));
            this.symbolDescription.setText(this.security.getName());
        }
        if (this.position != null) {
            this.quantity.setText(this.numberFormat.format(this.position));
        }
        if (this.limitPrice != null) {
            this.price.setText(this.priceFormat.format(this.limitPrice));
        }
        if (this.broker != null) {
            StructuredSelection selection = new StructuredSelection((Object)this.broker);
            this.brokerCombo.setSelection((ISelection)selection);
        } else {
            IBroker[] brokers = this.tradingService.getBrokers();
            if (brokers.length != 0) {
                this.brokerCombo.setSelection((ISelection)new StructuredSelection((Object)brokers[0]));
            }
        }
        this.handleBrokerSelection((IStructuredSelection)this.brokerCombo.getSelection());
        if (this.account != null) {
            this.accountCombo.setSelection((ISelection)new StructuredSelection((Object)this.account));
        }
        if (this.orderSide != null) {
            this.sideCombo.setSelection((ISelection)new StructuredSelection((Object)this.orderSide));
        }
    }

    protected void handleBrokerSelection(IStructuredSelection selection) {
        IBroker connector = (IBroker)selection.getFirstElement();
        if (this.security != null) {
            this.symbol.setText(connector.getSymbolFromSecurity(this.security));
            this.symbolDescription.setText(this.security.getName().replaceAll("&", "&&"));
        }
        IOrderSide[] sides = connector.getAllowedSides();
        ISelection oldSelection = this.sideCombo.getSelection();
        this.sideCombo.setInput((Object)sides);
        this.sideCombo.setSelection(oldSelection);
        if (this.sideCombo.getSelection().isEmpty()) {
            this.sideCombo.setSelection((ISelection)new StructuredSelection((Object)sides[0]));
        }
        IOrderType[] types = connector.getAllowedTypes();
        oldSelection = this.typeCombo.getSelection();
        this.typeCombo.setInput((Object)types);
        this.typeCombo.setSelection(oldSelection);
        if (this.typeCombo.getSelection().isEmpty() && types.length != 0) {
            this.typeCombo.setSelection((ISelection)new StructuredSelection((Object)types[0]));
        }
        IOrderValidity[] validities = connector.getAllowedValidity();
        oldSelection = this.validityCombo.getSelection();
        this.validityCombo.setInput((Object)validities);
        this.validityCombo.setSelection(oldSelection);
        if (this.validityCombo.getSelection().isEmpty() && validities.length != 0) {
            this.validityCombo.setSelection((ISelection)new StructuredSelection((Object)validities[0]));
        }
        IOrderRoute[] routes = connector.getAllowedRoutes();
        oldSelection = this.routeCombo.getSelection();
        this.routeCombo.setInput((Object)routes);
        this.routeCombo.setSelection(oldSelection);
        if (this.routeCombo.getSelection().isEmpty() && routes.length != 0) {
            this.routeCombo.setSelection((ISelection)new StructuredSelection((Object)routes[0]));
        }
        IAccount[] accounts = connector.getAccounts();
        oldSelection = this.accountCombo.getSelection();
        this.accountCombo.setInput((Object)accounts);
        this.accountCombo.setSelection(oldSelection);
        if (this.accountCombo.getSelection().isEmpty() && accounts.length != 0) {
            this.accountCombo.setSelection((ISelection)new StructuredSelection((Object)accounts[0]));
        }
        this.accountCombo.getControl().setEnabled(accounts.length > 0);
    }

    protected String getSecuritySymbol(ISecurity security) {
        IFeedIdentifier identifier = security.getIdentifier();
        if (identifier == null) {
            return null;
        }
        return identifier.getSymbol();
    }

    void addListeners() {
        this.symbol.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!OrderDialog.this.brokerCombo.getSelection().isEmpty()) {
                    IBroker connector = (IBroker)((IStructuredSelection)OrderDialog.this.brokerCombo.getSelection()).getFirstElement();
                    OrderDialog.this.security = connector.getSecurityFromSymbol(OrderDialog.this.symbol.getText());
                    OrderDialog.this.symbolDescription.setText(OrderDialog.this.security != null ? OrderDialog.this.security.getName() : "");
                }
                OrderDialog.this.getButton(0).setEnabled(OrderDialog.this.isValid());
            }
        });
        this.quantity.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OrderDialog.this.updateSummary();
                OrderDialog.this.getButton(0).setEnabled(OrderDialog.this.isValid());
            }
        });
        this.quantity.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                try {
                    long n = OrderDialog.this.numberFormat.parse(((Text)event.widget).getText()).longValue();
                    ((Text)event.widget).setText(OrderDialog.this.numberFormat.format(n));
                }
                catch (Exception exception) {}
            }
        });
        this.price.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OrderDialog.this.updateSummary();
                OrderDialog.this.getButton(0).setEnabled(OrderDialog.this.isValid());
            }
        });
        this.typeCombo.addSelectionChangedListener(this.orderTypeSelectionListener);
        this.brokerCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                OrderDialog.this.handleBrokerSelection(selection);
                OrderDialog.this.getButton(0).setEnabled(OrderDialog.this.isValid());
            }
        });
        this.validityCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IOrderValidity validity = selection.isEmpty() ? null : (IOrderValidity)selection.getFirstElement();
                OrderDialog.this.expireDate.setEnabled(validity == IOrderValidity.GoodTillDate);
                OrderDialog.this.getButton(0).setEnabled(OrderDialog.this.isValid());
            }
        });
    }

    protected void updateSummary() {
        try {
            long quantity = this.numberFormat.parse(this.quantity.getText()).longValue();
            double price = 0.0;
            IOrderType orderType = (IOrderType)((IStructuredSelection)this.typeCombo.getSelection()).getFirstElement();
            if (orderType == IOrderType.Limit || orderType == IOrderType.Stop || orderType == IOrderType.StopLimit) {
                price = this.priceFormat.parse(this.price.getText()).doubleValue();
            } else if (this.limitPrice != null) {
                price = this.limitPrice;
            }
            if (quantity != 0L && price != 0.0) {
                this.summaryLabel.setText(NLS.bind((String)Messages.OrderDialog_TotalLabel, (Object[])new Object[]{this.totalPriceFormat.format((double)quantity * price)}));
            } else {
                this.summaryLabel.setText("");
            }
        }
        catch (Exception exception) {
            this.summaryLabel.setText("");
        }
    }

    protected void okPressed() {
        try {
            IAccount account = (IAccount)((IStructuredSelection)this.accountCombo.getSelection()).getFirstElement();
            IOrderType orderType = (IOrderType)((IStructuredSelection)this.typeCombo.getSelection()).getFirstElement();
            Double limitPrice = orderType == IOrderType.Market ? null : Double.valueOf(this.priceFormat.parse(this.price.getText()).doubleValue());
            Order order = new Order(account, orderType, (IOrderSide)((IStructuredSelection)this.sideCombo.getSelection()).getFirstElement(), this.security, Long.valueOf(this.numberFormat.parse(this.quantity.getText()).longValue()), limitPrice);
            if (!this.routeCombo.getSelection().isEmpty()) {
                order.setRoute((IOrderRoute)((IStructuredSelection)this.routeCombo.getSelection()).getFirstElement());
            }
            if (!this.validityCombo.getSelection().isEmpty()) {
                IOrderValidity validity = (IOrderValidity)((IStructuredSelection)this.validityCombo.getSelection()).getFirstElement();
                order.setValidity(validity);
                if (this.expireDate.getEnabled()) {
                    order.setExpire(this.expireDate.getSelection());
                }
            }
            if (!this.orderReference.getText().equals("")) {
                order.setReference(this.orderReference.getText());
            }
            IBroker connector = (IBroker)((IStructuredSelection)this.brokerCombo.getSelection()).getFirstElement();
            IOrderMonitor tracker = connector.prepareOrder((IOrder)order);
            tracker.submit();
            super.okPressed();
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, Messages.OrderDialog_SubmitErrorMessage, (Throwable)e);
            UIActivator.log((IStatus)status);
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getShell().getText(), null, (IStatus)status);
        }
    }
}

