/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.trading.BrokerException;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderChangeListener;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IOrderStatus;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.core.trading.OrderChangeEvent;
import org.eclipsetrader.core.trading.OrderDelta;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.trading.Messages;
import org.eclipsetrader.ui.internal.trading.OrdersColumnsDialog;
import org.eclipsetrader.ui.internal.trading.ProxySelectionProvider;
import org.eclipsetrader.ui.trading.OrdersLabelProviderWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OrdersView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.views.orders";
    public static final String K_VISIBLE_COLUMNS = "VISIBLE_COLUMNS";
    private CTabFolder tabFolder;
    private TableViewer all;
    private TableViewer pending;
    private TableViewer filled;
    private TableViewer canceled;
    private TableViewer rejected;
    private ProxySelectionProvider selectionProvider;
    private IMemento memento;
    private IDialogSettings dialogSettings;
    private ServiceReference serviceReference;
    private ITradingService service;
    private IOrderChangeListener orderChangedListener = new IOrderChangeListener(){

        public void orderChanged(OrderChangeEvent event) {
            IAdapterManager adapterManager = Platform.getAdapterManager();
            OrderDelta[] orderDeltaArray = event.deltas;
            int n = event.deltas.length;
            int n2 = 0;
            while (n2 < n) {
                OrderDelta delta = orderDeltaArray[n2];
                PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)adapterManager.getAdapter((Object)delta.getOrder(), PropertyChangeSupport.class);
                if (propertyChangeSupport != null) {
                    if (delta.getKind() == 1) {
                        propertyChangeSupport.removePropertyChangeListener(OrdersView.this.propertyChangeListener);
                        propertyChangeSupport.addPropertyChangeListener(OrdersView.this.propertyChangeListener);
                    } else if (delta.getKind() == 2) {
                        propertyChangeSupport.removePropertyChangeListener(OrdersView.this.propertyChangeListener);
                    }
                }
                ++n2;
            }
            try {
                OrdersView.this.tabFolder.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!OrdersView.this.tabFolder.isDisposed()) {
                            OrdersView.this.all.refresh();
                            OrdersView.this.pending.refresh();
                            OrdersView.this.filled.refresh();
                            OrdersView.this.canceled.refresh();
                            OrdersView.this.rejected.refresh();
                        }
                    }
                });
            }
            catch (SWTException sWTException) {}
        }
    };
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                OrdersView.this.tabFolder.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!OrdersView.this.tabFolder.isDisposed()) {
                            OrdersView.this.all.refresh();
                            OrdersView.this.pending.refresh();
                            OrdersView.this.filled.refresh();
                            OrdersView.this.canceled.refresh();
                            OrdersView.this.rejected.refresh();
                        }
                    }
                });
            }
            catch (SWTException sWTException) {}
        }
    };
    private ControlAdapter columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            TableColumn tableColumn = (TableColumn)e.widget;
            int index = tableColumn.getParent().indexOf(tableColumn);
            String[] enabledId = OrdersView.this.dialogSettings.getArray(OrdersView.K_VISIBLE_COLUMNS);
            OrdersView.this.memento.putInteger(enabledId[index], tableColumn.getWidth());
        }
    };
    private Action cancelAction;
    private Action columnsAction;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento == null) {
            memento = XMLMemento.createWriteRoot((String)"root");
        }
        this.memento = memento;
        IDialogSettings pluginDialogSettings = UIActivator.getDefault().getDialogSettings();
        this.dialogSettings = pluginDialogSettings.getSection(VIEW_ID);
        if (this.dialogSettings == null) {
            this.dialogSettings = pluginDialogSettings.addNewSection(VIEW_ID);
            this.dialogSettings.put(K_VISIBLE_COLUMNS, new String[]{"org.eclipsetrader.ui.trading.orders.orderid", "org.eclipsetrader.ui.trading.orders.datetime", "org.eclipsetrader.ui.trading.orders.security", "org.eclipsetrader.ui.trading.orders.side", "org.eclipsetrader.ui.trading.orders.type", "org.eclipsetrader.ui.trading.orders.qty", "org.eclipsetrader.ui.trading.orders.price", "org.eclipsetrader.ui.trading.orders.filledqty", "org.eclipsetrader.ui.trading.orders.averageprice", "org.eclipsetrader.ui.trading.orders.status"});
        }
        this.initializeActions();
        IToolBarManager toolbarManager = site.getActionBars().getToolBarManager();
        toolbarManager.add((IContributionItem)new Separator("additions"));
        toolbarManager.add((IAction)this.cancelAction);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("group.new"));
        menuManager.add((IContributionItem)new GroupMarker("group.goto"));
        menuManager.add((IContributionItem)new Separator("group.open"));
        menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
        menuManager.add((IContributionItem)new Separator("group.show"));
        menuManager.add((IContributionItem)new Separator("group.edit"));
        menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
        menuManager.add((IContributionItem)new GroupMarker("group.port"));
        menuManager.add((IContributionItem)new Separator("group.generate"));
        menuManager.add((IContributionItem)new Separator("group.search"));
        menuManager.add((IContributionItem)new Separator("group.build"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("group.properties"));
        menuManager.appendToGroup("group.properties", (IAction)this.columnsAction);
        site.getActionBars().updateActionBars();
    }

    void initializeActions() {
        ISharedImages sharedImages = this.getViewSite().getWorkbenchWindow().getWorkbench().getSharedImages();
        this.cancelAction = new Action(Messages.OrdersView_CancelAction){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)OrdersView.this.getSite().getSelectionProvider().getSelection();
                if (!selection.isEmpty()) {
                    for (Object o : selection.toList()) {
                        try {
                            ((IOrderMonitor)o).cancel();
                        }
                        catch (BrokerException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        this.cancelAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.cancelAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.cancelAction.setEnabled(false);
        this.columnsAction = new Action(Messages.OrdersView_ColumnsAction){

            public void run() {
                OrdersColumnsDialog dlg = new OrdersColumnsDialog(OrdersView.this.getSite().getShell());
                dlg.setVisibleId(OrdersView.this.dialogSettings.getArray(OrdersView.K_VISIBLE_COLUMNS));
                if (dlg.open() == 0) {
                    OrdersView.this.dialogSettings.put(OrdersView.K_VISIBLE_COLUMNS, dlg.getVisibleId());
                    OrdersView.this.updateViewerColumns(OrdersView.this.all, true);
                    OrdersView.this.updateViewerColumns(OrdersView.this.pending, false);
                    OrdersView.this.updateViewerColumns(OrdersView.this.filled, false);
                    OrdersView.this.updateViewerColumns(OrdersView.this.canceled, false);
                    OrdersView.this.updateViewerColumns(OrdersView.this.rejected, false);
                    OrdersView.this.all.refresh();
                    OrdersView.this.pending.refresh();
                    OrdersView.this.filled.refresh();
                    OrdersView.this.canceled.refresh();
                    OrdersView.this.rejected.refresh();
                }
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.createTabFolder(parent);
        this.tabFolder.setSelection(this.tabFolder.getItem(0));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewer viewer = (TableViewer)((CTabItem)e.item).getControl().getData("viewer");
                if (viewer != null) {
                    OrdersView.this.selectionProvider.setSelectionProvider((ISelectionProvider)viewer);
                }
            }
        });
        this.selectionProvider = new ProxySelectionProvider();
        this.selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = false;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                for (Object o : selection.toList()) {
                    if (((IOrderMonitor)o).getStatus() == IOrderStatus.Canceled) continue;
                    enabled = true;
                }
                OrdersView.this.cancelAction.setEnabled(enabled);
            }
        });
        this.selectionProvider.setSelectionProvider((ISelectionProvider)this.all);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("group.new"));
                menuManager.add((IContributionItem)new GroupMarker("group.goto"));
                menuManager.add((IContributionItem)new Separator("group.open"));
                menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
                menuManager.add((IContributionItem)new Separator("group.show"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
                menuManager.add((IContributionItem)new GroupMarker("group.port"));
                menuManager.add((IContributionItem)new Separator("group.generate"));
                menuManager.add((IContributionItem)new Separator("group.search"));
                menuManager.add((IContributionItem)new Separator("group.build"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("group.properties"));
                menuManager.appendToGroup("group.build", (IAction)OrdersView.this.cancelAction);
            }
        });
        this.all.getControl().setMenu(menuMgr.createContextMenu(this.all.getControl()));
        this.pending.getControl().setMenu(menuMgr.createContextMenu(this.pending.getControl()));
        this.filled.getControl().setMenu(menuMgr.createContextMenu(this.filled.getControl()));
        this.canceled.getControl().setMenu(menuMgr.createContextMenu(this.canceled.getControl()));
        this.rejected.getControl().setMenu(menuMgr.createContextMenu(this.rejected.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
        if (UIActivator.getDefault() != null) {
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            this.serviceReference = context.getServiceReference(ITradingService.class.getName());
            if (this.serviceReference != null) {
                this.service = (ITradingService)context.getService(this.serviceReference);
                this.all.setInput((Object)this.service);
                this.pending.setInput((Object)this.service);
                this.filled.setInput((Object)this.service);
                this.canceled.setInput((Object)this.service);
                this.rejected.setInput((Object)this.service);
                this.hookListeners(this.service.getOrders());
                this.service.addOrderChangeListener(this.orderChangedListener);
            }
        }
    }

    public void dispose() {
        if (this.service != null) {
            this.service.removeOrderChangeListener(this.orderChangedListener);
            this.unhookListeners(this.service.getOrders());
        }
        if (this.serviceReference != null) {
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            context.ungetService(this.serviceReference);
        }
        super.dispose();
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    protected void createTabFolder(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(Messages.OrdersView_AllTab);
        this.all = this.createViewer((Composite)this.tabFolder, true);
        tabItem.setControl(this.all.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(Messages.OrdersView_PendingTab);
        this.pending = this.createViewer((Composite)this.tabFolder, false);
        this.pending.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IOrderMonitor order = (IOrderMonitor)element;
                return order.getStatus() == IOrderStatus.PendingCancel || order.getStatus() == IOrderStatus.PendingNew;
            }
        }});
        tabItem.setControl(this.pending.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(Messages.OrdersView_FilledTab);
        this.filled = this.createViewer((Composite)this.tabFolder, false);
        this.filled.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IOrderMonitor order = (IOrderMonitor)element;
                return order.getStatus() == IOrderStatus.Filled;
            }
        }});
        tabItem.setControl(this.filled.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(Messages.OrdersView_CanceledTab);
        this.canceled = this.createViewer((Composite)this.tabFolder, false);
        this.canceled.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IOrderMonitor order = (IOrderMonitor)element;
                return order.getStatus() == IOrderStatus.Canceled || order.getStatus() == IOrderStatus.Expired;
            }
        }});
        tabItem.setControl(this.canceled.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(Messages.OrdersView_RejectedTab);
        this.rejected = this.createViewer((Composite)this.tabFolder, false);
        this.rejected.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IOrderMonitor order = (IOrderMonitor)element;
                return order.getStatus() == IOrderStatus.Rejected;
            }
        }});
        tabItem.setControl(this.rejected.getControl());
    }

    public void saveState(IMemento memento) {
        memento.putMemento(this.memento);
        super.saveState(memento);
    }

    protected TableViewer createViewer(Composite parent, boolean wrapLabelProviders) {
        TableViewer viewer = new TableViewer(parent, 65538);
        viewer.getTable().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((ITradingService)inputElement).getOrders();
            }
        });
        viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IOrder o1 = ((IOrderMonitor)e1).getOrder();
                IOrder o2 = ((IOrderMonitor)e2).getOrder();
                return o2.getDate().compareTo(o1.getDate());
            }
        });
        this.updateViewerColumns(viewer, wrapLabelProviders);
        return viewer;
    }

    IConfigurationElement getConfigurationElement(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipsetrader.ui.viewLabelProviders");
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            if ("viewContribution".equals(configElements[i].getName())) {
                configElements = configElements[i].getChildren();
                int j = 0;
                while (j < configElements.length) {
                    String strID = configElements[j].getAttribute("id");
                    if (targetID.equals(strID)) {
                        return configElements[j];
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return null;
    }

    protected void updateViewerColumns(TableViewer viewer, boolean wrapLabelProviders) {
        viewer.getTable().setRedraw(false);
        try {
            TableColumn[] tableColumn = viewer.getTable().getColumns();
            int i = 0;
            while (i < tableColumn.length) {
                tableColumn[i].dispose();
                ++i;
            }
            String[] enabledId = this.dialogSettings.getArray(K_VISIBLE_COLUMNS);
            int i2 = 0;
            while (i2 < enabledId.length) {
                IConfigurationElement element = this.getConfigurationElement(enabledId[i2]);
                if (element != null) {
                    int style = 16384;
                    if ("right".equals(element.getAttribute("orientation"))) {
                        style = 131072;
                    } else if ("center".equals(element.getAttribute("orientation"))) {
                        style = 0x1000000;
                    }
                    TableViewerColumn viewerColumn = new TableViewerColumn(viewer, style);
                    viewerColumn.getColumn().setText(element.getAttribute("name"));
                    viewerColumn.getColumn().setWidth(this.memento != null && this.memento.getString(enabledId[i2]) != null ? this.memento.getInteger(enabledId[i2]) : 64);
                    viewerColumn.getColumn().addControlListener((ControlListener)this.columnControlListener);
                    try {
                        ColumnLabelProvider labelProvider = (ColumnLabelProvider)element.createExecutableExtension("class");
                        if (wrapLabelProviders) {
                            labelProvider = new OrdersLabelProviderWrapper(labelProvider);
                        }
                        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
                    }
                    catch (Exception e) {
                        Status status = new Status(2, "org.eclipsetrader.ui", String.valueOf(Messages.OrdersView_ErrorCreatingLabelProvider) + enabledId[i2], (Throwable)e);
                        UIActivator.log((IStatus)status);
                    }
                }
                ++i2;
            }
        }
        finally {
            viewer.getTable().setRedraw(true);
        }
    }

    protected void hookListeners(IOrderMonitor[] order) {
        IAdapterManager adapterManager = Platform.getAdapterManager();
        int i = 0;
        while (i < order.length) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)adapterManager.getAdapter((Object)order[i], PropertyChangeSupport.class);
            if (propertyChangeSupport != null) {
                propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
                propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
            }
            ++i;
        }
    }

    protected void unhookListeners(IOrderMonitor[] order) {
        IAdapterManager adapterManager = Platform.getAdapterManager();
        int i = 0;
        while (i < order.length) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)adapterManager.getAdapter((Object)order[i], PropertyChangeSupport.class);
            if (propertyChangeSupport != null) {
                propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
            }
            ++i;
        }
    }
}

