/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.internal.trading.TargetPrice;
import org.eclipsetrader.ui.internal.trading.Messages;

public class TargetPricePropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    Combo field;
    Spinner value;
    Button cross;
    Label description;
    private SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TargetPricePropertyPage.this.description.setText(TargetPricePropertyPage.this.getDescriptionText());
        }
    };

    public TargetPricePropertyPage() {
        this.setTitle(Messages.TargetPricePropertyPage_Title);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.TargetPricePropertyPage_PriceField);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(50), -1));
        this.field = new Combo(content, 12);
        this.field.setItems(new String[]{Messages.TargetPricePropertyPage_LastFieldText, Messages.TargetPricePropertyPage_BidFieldText, Messages.TargetPricePropertyPage_AskFieldText});
        this.field.select(0);
        this.field.addSelectionListener((SelectionListener)this.selectionListener);
        label = new Label(content, 0);
        label.setText(Messages.TargetPricePropertyPage_ValueLabel);
        this.value = new Spinner(content, 2048);
        this.value.setDigits(4);
        this.value.setMinimum(0);
        this.value.setMaximum(99999999);
        this.value.addSelectionListener((SelectionListener)this.selectionListener);
        label = new Label(content, 0);
        this.cross = new Button(content, 32);
        this.cross.setText(Messages.TargetPricePropertyPage_TriggerIfCrossedLabel);
        this.cross.addSelectionListener((SelectionListener)this.selectionListener);
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.description = new Label(content, 0);
        this.description.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        TargetPrice element = (TargetPrice)this.getElement().getAdapter(TargetPrice.class);
        Map map = element.getParameters();
        this.field.select(((Integer)map.get("field")).intValue());
        this.value.setSelection((int)((Double)map.get("price") * Math.pow(10.0, this.value.getDigits())));
        this.cross.setSelection(((Boolean)map.get("cross")).booleanValue());
        this.description.setText(this.getDescriptionText());
    }

    public boolean performOk() {
        if (this.isControlCreated()) {
            TargetPrice element = (TargetPrice)this.getElement().getAdapter(TargetPrice.class);
            element.setParameters(this.getParametersMap());
        }
        return super.performOk();
    }

    Map<String, Object> getParametersMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("field", this.field.getSelectionIndex());
        map.put("price", (double)this.value.getSelection() / Math.pow(10.0, this.value.getDigits()));
        map.put("cross", this.cross.getSelection());
        return map;
    }

    String getDescriptionText() {
        return TargetPrice.getDescriptionFor(this.getParametersMap());
    }
}

