/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipsetrader.core.internal.trading.TargetPrice;
import org.eclipsetrader.ui.internal.trading.Messages;

public class TargetPriceWizardPage
extends WizardPage {
    Combo field;
    Spinner value;
    Button cross;
    Label description;
    private SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TargetPriceWizardPage.this.description.setText(TargetPriceWizardPage.this.getDescriptionText());
        }
    };

    public TargetPriceWizardPage() {
        super("general", Messages.TargetPriceWizardPage_Title, null);
        this.setDescription(Messages.TargetPriceWizardPage_Description);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        this.setControl((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.TargetPriceWizardPage_PriceFieldLabel);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.field = new Combo(content, 12);
        this.field.setItems(new String[]{Messages.TargetPriceWizardPage_LastFieldText, Messages.TargetPriceWizardPage_BidFieldText, Messages.TargetPriceWizardPage_AskFieldText});
        this.field.select(0);
        this.field.addSelectionListener((SelectionListener)this.selectionListener);
        label = new Label(content, 0);
        label.setText(Messages.TargetPriceWizardPage_ValueLabel);
        this.value = new Spinner(content, 2048);
        this.value.setDigits(4);
        this.value.setMinimum(0);
        this.value.setMaximum(99999999);
        this.value.addSelectionListener((SelectionListener)this.selectionListener);
        label = new Label(content, 0);
        this.cross = new Button(content, 32);
        this.cross.setText(Messages.TargetPriceWizardPage_TriggerIfCrossedLabel);
        this.cross.addSelectionListener((SelectionListener)this.selectionListener);
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.description = new Label(content, 0);
        this.description.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
    }

    public Map<String, Object> getParametersMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("field", this.field.getSelectionIndex());
        map.put("price", (double)this.value.getSelection() / Math.pow(10.0, this.value.getDigits()));
        map.put("cross", this.cross.getSelection());
        return map;
    }

    String getDescriptionText() {
        return TargetPrice.getDescriptionFor(this.getParametersMap());
    }
}

