/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.trading.OrderDialog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TradeHandler
extends AbstractHandler {
    public static final String PARAM_BROKER = "broker";
    public static final String PARAM_LIMIT_PRICE = "limitPrice";
    public static final String PARAM_SIDE = "side";
    BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
    ServiceReference serviceReference = this.context.getServiceReference(ITradingService.class.getName());
    ITradingService tradingService = (ITradingService)this.context.getService(this.serviceReference);

    public void dispose() {
        this.context.ungetService(this.serviceReference);
        super.dispose();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty()) {
            for (IAdaptable target : selection) {
                this.openDialog(event, site, target);
            }
        }
        return null;
    }

    private void openDialog(ExecutionEvent event, IWorkbenchSite site, IAdaptable target) {
        String limitPrice;
        OrderDialog dlg = new OrderDialog(site.getShell(), this.tradingService);
        ISecurity security = (ISecurity)target.getAdapter(ISecurity.class);
        dlg.setSecurity(security);
        String brokerId = event.getParameter(PARAM_BROKER);
        if (brokerId != null) {
            dlg.setBroker(this.tradingService.getBroker(brokerId));
        } else {
            IBroker broker = (IBroker)target.getAdapter(IBroker.class);
            if (broker == null) {
                broker = this.tradingService.getBrokerForSecurity(security);
            }
            dlg.setBroker(broker);
            IAccount account = (IAccount)target.getAdapter(IAccount.class);
            dlg.setAccount(account);
        }
        IPosition position = (IPosition)target.getAdapter(IPosition.class);
        if (position != null) {
            dlg.setPosition(position.getQuantity());
        }
        if ((limitPrice = event.getParameter(PARAM_LIMIT_PRICE)) != null) {
            dlg.setLimitPrice(Double.parseDouble(limitPrice));
        } else {
            ITrade trade = (ITrade)target.getAdapter(ITrade.class);
            if (trade != null && trade.getPrice() != null) {
                dlg.setLimitPrice(trade.getPrice());
            }
        }
        String side = event.getParameter(PARAM_SIDE);
        if (side != null) {
            if (IOrderSide.Buy.getId().equals(side)) {
                dlg.setOrderSide(IOrderSide.Buy);
            } else if (IOrderSide.Sell.getId().equals(side)) {
                dlg.setOrderSide(IOrderSide.Sell);
            } else if (IOrderSide.BuyCover.getId().equals(side)) {
                dlg.setOrderSide(IOrderSide.BuyCover);
            } else if (IOrderSide.SellShort.getId().equals(side)) {
                dlg.setOrderSide(IOrderSide.SellShort);
            }
        } else if (position != null) {
            dlg.setOrderSide(position.getQuantity() > 0L ? IOrderSide.Sell : IOrderSide.Buy);
        }
        dlg.open();
    }
}

