/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.AlertEvent;
import org.eclipsetrader.core.trading.IAlertListener;
import org.eclipsetrader.core.trading.IAlertService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class WatchlistAlertDecorator
implements ILightweightLabelDecorator,
IAlertListener {
    private Color foreground;
    private ListenerList listeners = new ListenerList(1);
    private ServiceReference serviceReference;
    private IAlertService alertService;

    public WatchlistAlertDecorator() {
        this(UIActivator.getDefault().getBundle().getBundleContext());
    }

    protected WatchlistAlertDecorator(BundleContext context) {
        this.serviceReference = context.getServiceReference(IAlertService.class.getName());
        this.alertService = (IAlertService)context.getService(this.serviceReference);
        this.alertService.addAlertListener((IAlertListener)this);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IAdaptable) {
            element = ((IAdaptable)element).getAdapter(ISecurity.class);
        }
        if (element == null || !(element instanceof ISecurity)) {
            return;
        }
        decoration.addPrefix("*");
        if (this.alertService.hasTriggeredAlerts((ISecurity)element)) {
            if (this.foreground == null) {
                this.foreground = new Color((Device)Display.getDefault(), 255, 0, 0);
            }
            decoration.setBackgroundColor(this.foreground);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void dispose() {
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        this.alertService.removeAlertListener((IAlertListener)this);
        context.ungetService(this.serviceReference);
        if (this.foreground != null) {
            this.foreground.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void alertTriggered(AlertEvent event) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        final Object[] l = this.listeners.getListeners();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < l.length) {
                    try {
                        ((ILabelProviderListener)l[i]).labelProviderChanged(event);
                    }
                    catch (Throwable t) {
                        Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error notifying listeners", t);
                        UIActivator.log((IStatus)status);
                    }
                    ++i;
                }
            }
        });
    }
}

