/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading.portfolio;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;
import org.eclipsetrader.ui.internal.trading.portfolio.AccountElement;

public class BrokerElement
extends PlatformObject
implements IViewItem,
IWorkbenchAdapter {
    IBroker broker;
    List<AccountElement> childs;

    public BrokerElement(IBroker broker) {
        this.broker = broker;
        this.childs = new ArrayList<AccountElement>();
        IAccount[] iAccountArray = broker.getAccounts();
        int n = iAccountArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAccount account = iAccountArray[n2];
            this.childs.add(new AccountElement(this, account));
            ++n2;
        }
    }

    public void accept(IViewItemVisitor visitor) {
        if (visitor.visit((IViewItem)this)) {
            for (AccountElement element : this.childs) {
                element.accept(visitor);
            }
        }
    }

    public int getItemCount() {
        return this.childs.size();
    }

    public IViewItem[] getItems() {
        return this.childs.toArray(new IViewItem[this.childs.size()]);
    }

    public IViewItem getParent() {
        return null;
    }

    public IAdaptable[] getValues() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.broker.getClass())) {
            return this.broker;
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BrokerElement)) {
            return false;
        }
        return this.broker.equals(((BrokerElement)((Object)obj)).broker);
    }

    public int hashCode() {
        return 11 * this.broker.hashCode();
    }

    public Object[] getChildren(Object o) {
        return this.childs.toArray(new IViewItem[this.childs.size()]);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.broker.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public String toString() {
        return this.broker.getName();
    }
}

