/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading.portfolio;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;

public class PositionElement
extends PlatformObject
implements IViewItem,
IWorkbenchAdapter {
    IViewItem parent;
    IPosition position;
    ITrade trade;

    public PositionElement(IViewItem parent, IPosition position) {
        this.parent = parent;
        this.position = position;
    }

    public void setTrade(ITrade trade) {
        this.trade = trade;
    }

    public void accept(IViewItemVisitor visitor) {
        visitor.visit((IViewItem)this);
    }

    public int getItemCount() {
        return 0;
    }

    public IViewItem[] getItems() {
        return null;
    }

    public IViewItem getParent() {
        return this.parent;
    }

    public IAdaptable[] getValues() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        IAccount account;
        IBroker broker;
        if (adapter.isAssignableFrom(this.position.getClass())) {
            return this.position;
        }
        if (adapter.isAssignableFrom(this.position.getSecurity().getClass())) {
            return this.position.getSecurity();
        }
        if (adapter.isAssignableFrom(ITrade.class)) {
            return this.trade;
        }
        if (this.trade != null && adapter.isAssignableFrom(this.trade.getClass())) {
            return this.trade;
        }
        if (adapter.isAssignableFrom(IBroker.class) && (broker = (IBroker)this.parent.getAdapter(IBroker.class)) != null) {
            return broker;
        }
        if (adapter.isAssignableFrom(IAccount.class) && (account = (IAccount)this.parent.getAdapter(IAccount.class)) != null) {
            return account;
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PositionElement)) {
            return false;
        }
        return this.position.equals(((PositionElement)((Object)obj)).position);
    }

    public int hashCode() {
        return 11 * this.position.hashCode();
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.position.getSecurity().getName();
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public String toString() {
        return this.position.getSecurity().getName();
    }
}

