/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipsetrader.core.feed.IBookEntry;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.ui.internal.UIActivator;

public class Level2QuickTradeDecorator
implements MouseTrackListener,
MouseMoveListener,
SelectionListener {
    Table table;
    ICommandService commandService;
    IHandlerService handlerService;
    Cursor buyCursor;
    Cursor sellCursor;
    boolean entered;

    public Level2QuickTradeDecorator(Table table, ICommandService commandService, IHandlerService handlerService) {
        this.table = table;
        this.commandService = commandService;
        this.handlerService = handlerService;
        this.initializeCursors();
        table.addMouseTrackListener((MouseTrackListener)this);
        table.addMouseMoveListener((MouseMoveListener)this);
        table.addSelectionListener((SelectionListener)this);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Level2QuickTradeDecorator.this.buyCursor.dispose();
                Level2QuickTradeDecorator.this.sellCursor.dispose();
            }
        });
    }

    void initializeCursors() {
        ImageDescriptor sourceDescriptor = UIActivator.getImageDescriptor("icons/pointers/buysell-source.bmp");
        ImageDescriptor buyMaskDescriptor = UIActivator.getImageDescriptor("icons/pointers/buy-mask.bmp");
        ImageDescriptor sellMaskDescriptor = UIActivator.getImageDescriptor("icons/pointers/sell-mask.bmp");
        this.buyCursor = new Cursor((Device)Display.getCurrent(), sourceDescriptor.getImageData(), buyMaskDescriptor.getImageData(), 15, 7);
        this.sellCursor = new Cursor((Device)Display.getCurrent(), sourceDescriptor.getImageData(), sellMaskDescriptor.getImageData(), 15, 7);
    }

    public void mouseEnter(MouseEvent e) {
        this.entered = true;
    }

    public void mouseMove(MouseEvent e) {
        int x = 0;
        if (!this.entered) {
            return;
        }
        if (this.table.getItem(new Point(e.x, e.y)) == null) {
            this.table.setCursor(null);
            return;
        }
        TableColumn[] column = this.table.getColumns();
        int i = 0;
        while (i < column.length / 2) {
            if (e.x >= x && e.x <= x + column[i].getWidth()) {
                if (this.table.getCursor() != this.buyCursor) {
                    this.table.setCursor(this.buyCursor);
                }
                return;
            }
            x += column[i].getWidth();
            ++i;
        }
        while (i < column.length) {
            if (e.x >= x && e.x <= x + column[i].getWidth()) {
                if (this.table.getCursor() != this.sellCursor) {
                    this.table.setCursor(this.sellCursor);
                }
                return;
            }
            x += column[i].getWidth();
            ++i;
        }
    }

    public void mouseExit(MouseEvent e) {
        if (this.entered) {
            this.table.setCursor(null);
        }
        this.entered = false;
    }

    public void mouseHover(MouseEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        IBookEntry entry = null;
        IOrderSide orderSide = null;
        if (this.table.getCursor() == this.buyCursor) {
            entry = (IBookEntry)e.item.getData("bid");
            orderSide = IOrderSide.Buy;
        } else if (this.table.getCursor() == this.sellCursor) {
            entry = (IBookEntry)e.item.getData("ask");
            orderSide = IOrderSide.Sell;
        }
        if (entry == null) {
            return;
        }
        Command tradeCommand = this.commandService.getCommand("org.eclipsetrader.ui.file.trade");
        if (tradeCommand != null) {
            try {
                IParameter limitPrice = tradeCommand.getParameter("limitPrice");
                IParameter side = tradeCommand.getParameter("side");
                ParameterizedCommand parmCommand = new ParameterizedCommand(tradeCommand, new Parameterization[]{new Parameterization(limitPrice, Double.toString(entry.getPrice())), new Parameterization(side, orderSide.getId())});
                this.handlerService.executeCommand(parmCommand, null);
            }
            catch (Exception e1) {
                UIActivator.log("Error executing org.eclipsetrader.ui.file.trade command", e1);
            }
        }
    }
}

